/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline.nodePipeline.regression;

import org.neo4j.gds.GraphStoreAlgorithmFactory;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.Task;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.ml.pipeline.PipelineCatalog;
import org.neo4j.gds.ml.pipeline.PipelineCompanion;
import org.neo4j.gds.ml.pipeline.nodePipeline.NodeFeatureProducer;
import org.neo4j.gds.ml.pipeline.nodePipeline.regression.NodeRegressionPipelineTrainConfig;
import org.neo4j.gds.ml.pipeline.nodePipeline.regression.NodeRegressionTrain;
import org.neo4j.gds.ml.pipeline.nodePipeline.regression.NodeRegressionTrainAlgorithm;
import org.neo4j.gds.ml.pipeline.nodePipeline.regression.NodeRegressionTrainingPipeline;

public class NodeRegressionTrainPipelineAlgorithmFactory
extends GraphStoreAlgorithmFactory<NodeRegressionTrainAlgorithm, NodeRegressionPipelineTrainConfig> {
    private final ExecutionContext executionContext;

    public NodeRegressionTrainPipelineAlgorithmFactory(ExecutionContext executionContext) {
        this.executionContext = executionContext;
    }

    public NodeRegressionTrainAlgorithm build(GraphStore graphStore, NodeRegressionPipelineTrainConfig configuration, ProgressTracker progressTracker) {
        NodeRegressionTrainingPipeline pipeline = PipelineCatalog.getTyped(configuration.username(), configuration.pipeline(), NodeRegressionTrainingPipeline.class);
        return this.build(graphStore, configuration, pipeline, progressTracker);
    }

    public NodeRegressionTrainAlgorithm build(GraphStore graphStore, NodeRegressionPipelineTrainConfig configuration, NodeRegressionTrainingPipeline pipeline, ProgressTracker progressTracker) {
        PipelineCompanion.validateMainMetric(pipeline, configuration.metrics().get(0).toString());
        NodeFeatureProducer<NodeRegressionPipelineTrainConfig> nodeFeatureProducer = NodeFeatureProducer.create(graphStore, configuration, this.executionContext, progressTracker);
        nodeFeatureProducer.validateNodePropertyStepsContextConfigs(pipeline.nodePropertySteps());
        return new NodeRegressionTrainAlgorithm(NodeRegressionTrain.create(graphStore, pipeline, configuration, nodeFeatureProducer, progressTracker), pipeline, graphStore, configuration, progressTracker);
    }

    public String taskName() {
        return "Node Regression Train Pipeline";
    }

    public Task progressTask(GraphStore graphStore, NodeRegressionPipelineTrainConfig config) {
        NodeRegressionTrainingPipeline pipeline = PipelineCatalog.getTyped(config.username(), config.pipeline(), NodeRegressionTrainingPipeline.class);
        return NodeRegressionTrainPipelineAlgorithmFactory.progressTask(pipeline, graphStore.nodeCount());
    }

    public static Task progressTask(NodeRegressionTrainingPipeline pipeline, long nodeCount) {
        return NodeRegressionTrain.progressTask(pipeline, nodeCount);
    }
}

