/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline.nodePipeline.classification.train;

import java.util.List;
import java.util.Map;
import org.immutables.value.Value;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.config.ToMapConvertible;
import org.neo4j.gds.ml.metrics.Metric;
import org.neo4j.gds.ml.metrics.ModelCandidateStats;
import org.neo4j.gds.ml.models.TrainerConfig;
import org.neo4j.gds.ml.pipeline.nodePipeline.NodePropertyPredictPipeline;
import org.neo4j.gds.ml.pipeline.nodePipeline.classification.train.ImmutableNodeClassificationPipelineModelInfo;

@ValueClass
public interface NodeClassificationPipelineModelInfo
extends ToMapConvertible {
    public TrainerConfig bestParameters();

    public Map<String, Object> metrics();

    public NodePropertyPredictPipeline pipeline();

    public List<Long> classes();

    @Value.Auxiliary
    @Value.Derived
    default public Map<String, Object> toMap() {
        return Map.of("bestParameters", this.bestParameters().toMapWithTrainerMethod(), "classes", this.classes(), "metrics", this.metrics(), "pipeline", this.pipeline().toMap(), "nodePropertySteps", ToMapConvertible.toMap(this.pipeline().nodePropertySteps()), "featureProperties", this.pipeline().featureProperties());
    }

    public static NodeClassificationPipelineModelInfo of(Map<Metric, Double> testMetrics, Map<Metric, Double> outerTrainMetrics, ModelCandidateStats bestCandidate, NodePropertyPredictPipeline pipeline, List<Long> classes) {
        Map metrics = bestCandidate.renderMetrics(testMetrics, outerTrainMetrics);
        return ImmutableNodeClassificationPipelineModelInfo.of(bestCandidate.trainerConfig(), metrics, pipeline, classes);
    }
}

