/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline.nodePipeline;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.config.ToMapConvertible;
import org.neo4j.gds.ml.pipeline.ExecutableNodePropertyStep;
import org.neo4j.gds.ml.pipeline.NodePropertyStep;
import org.neo4j.gds.ml.pipeline.Pipeline;
import org.neo4j.gds.ml.pipeline.nodePipeline.NodeFeatureStep;

public final class NodePropertyPredictPipeline
implements Pipeline<NodeFeatureStep> {
    public static final NodePropertyPredictPipeline EMPTY = new NodePropertyPredictPipeline(List.of(), List.of());
    private final List<ExecutableNodePropertyStep> nodePropertySteps;
    private final List<NodeFeatureStep> featureSteps;

    private NodePropertyPredictPipeline(List<ExecutableNodePropertyStep> nodePropertySteps, List<NodeFeatureStep> featureSteps) {
        this.nodePropertySteps = nodePropertySteps;
        this.featureSteps = featureSteps;
    }

    public static NodePropertyPredictPipeline from(Pipeline<NodeFeatureStep> pipeline) {
        return new NodePropertyPredictPipeline(List.copyOf(pipeline.nodePropertySteps()), List.copyOf(pipeline.featureSteps()));
    }

    public static NodePropertyPredictPipeline from(Stream<NodePropertyStep> nodePropertySteps, Stream<NodeFeatureStep> featureSteps) {
        return new NodePropertyPredictPipeline(nodePropertySteps.collect(Collectors.toList()), featureSteps.collect(Collectors.toList()));
    }

    public Map<String, Object> toMap() {
        return Map.of("nodePropertySteps", ToMapConvertible.toMap(this.nodePropertySteps()), "featureProperties", ToMapConvertible.toMap(this.featureSteps()));
    }

    @Override
    public List<ExecutableNodePropertyStep> nodePropertySteps() {
        return this.nodePropertySteps;
    }

    @Override
    public List<NodeFeatureStep> featureSteps() {
        return this.featureSteps;
    }

    @Override
    public void specificValidateBeforeExecution(GraphStore graphStore) {
    }

    @Override
    public List<String> featureProperties() {
        return this.featureSteps().stream().flatMap(step -> step.inputNodeProperties().stream()).collect(Collectors.toList());
    }
}

