/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline.nodePipeline;

import java.util.Collection;
import java.util.List;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.ml.models.Features;
import org.neo4j.gds.ml.models.FeaturesFactory;
import org.neo4j.gds.ml.pipeline.ExecutableNodePropertyStep;
import org.neo4j.gds.ml.pipeline.NodePropertyStepExecutor;
import org.neo4j.gds.ml.pipeline.nodePipeline.NodePropertyPipelineBaseTrainConfig;
import org.neo4j.gds.ml.pipeline.nodePipeline.NodePropertyTrainingPipeline;

public final class NodeFeatureProducer<PIPELINE_CONFIG extends NodePropertyPipelineBaseTrainConfig> {
    private final NodePropertyStepExecutor<PIPELINE_CONFIG> stepExecutor;
    private final GraphStore graphStore;
    private final PIPELINE_CONFIG trainConfig;

    private NodeFeatureProducer(NodePropertyStepExecutor<PIPELINE_CONFIG> stepExecutor, GraphStore graphStore, PIPELINE_CONFIG trainConfig) {
        this.stepExecutor = stepExecutor;
        this.graphStore = graphStore;
        this.trainConfig = trainConfig;
    }

    public static <PIPELINE_CONFIG extends NodePropertyPipelineBaseTrainConfig> NodeFeatureProducer<PIPELINE_CONFIG> create(GraphStore graphStore, PIPELINE_CONFIG config, ExecutionContext executionContext, ProgressTracker progressTracker) {
        return new NodeFeatureProducer<PIPELINE_CONFIG>(NodePropertyStepExecutor.of(executionContext, graphStore, config, config.nodeLabelIdentifiers(graphStore), config.internalRelationshipTypes(graphStore), graphStore.relationshipTypes(), progressTracker), graphStore, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Features procedureFeatures(NodePropertyTrainingPipeline pipeline) {
        try {
            this.stepExecutor.executeNodePropertySteps(pipeline.nodePropertySteps());
            Collection targetNodeLabels = this.trainConfig.nodeLabelIdentifiers(this.graphStore);
            pipeline.validateFeatureProperties(this.graphStore, targetNodeLabels);
            Graph targetNodeLabelGraph = this.graphStore.getGraph(targetNodeLabels);
            if (pipeline.requireEagerFeatures()) {
                Features features = FeaturesFactory.extractEagerFeatures((Graph)targetNodeLabelGraph, pipeline.featureProperties());
                return features;
            }
            Features features = FeaturesFactory.extractLazyFeatures((Graph)targetNodeLabelGraph, pipeline.featureProperties());
            return features;
        }
        finally {
            this.stepExecutor.cleanupIntermediateProperties(pipeline.nodePropertySteps());
        }
    }

    public void validateNodePropertyStepsContextConfigs(List<ExecutableNodePropertyStep> steps) {
        this.stepExecutor.validNodePropertyStepsContextConfigs(steps);
    }
}

