/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline.linkPipeline.train;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.core.model.Model;
import org.neo4j.gds.ml.models.Classifier;
import org.neo4j.gds.ml.pipeline.linkPipeline.LinkPredictionModelInfo;
import org.neo4j.gds.ml.pipeline.linkPipeline.train.LinkPredictionTrainConfig;
import org.neo4j.gds.ml.pipeline.linkPipeline.train.LinkPredictionTrainPipelineExecutor;
import org.neo4j.gds.ml.training.TrainingStatistics;

@ParametersAreNonnullByDefault
@Generated(from="LinkPredictionTrainPipelineExecutor.LinkPredictionTrainPipelineResult", generator="Immutables")
@Immutable
public final class ImmutableLinkPredictionTrainPipelineResult
implements LinkPredictionTrainPipelineExecutor.LinkPredictionTrainPipelineResult {
    private final Model<Classifier.ClassifierData, LinkPredictionTrainConfig, LinkPredictionModelInfo> model;
    private final TrainingStatistics trainingStatistics;

    private ImmutableLinkPredictionTrainPipelineResult(Model<Classifier.ClassifierData, LinkPredictionTrainConfig, LinkPredictionModelInfo> model, TrainingStatistics trainingStatistics) {
        this.model = Objects.requireNonNull(model, "model");
        this.trainingStatistics = Objects.requireNonNull(trainingStatistics, "trainingStatistics");
    }

    private ImmutableLinkPredictionTrainPipelineResult(ImmutableLinkPredictionTrainPipelineResult original, Model<Classifier.ClassifierData, LinkPredictionTrainConfig, LinkPredictionModelInfo> model, TrainingStatistics trainingStatistics) {
        this.model = model;
        this.trainingStatistics = trainingStatistics;
    }

    public Model<Classifier.ClassifierData, LinkPredictionTrainConfig, LinkPredictionModelInfo> model() {
        return this.model;
    }

    @Override
    public TrainingStatistics trainingStatistics() {
        return this.trainingStatistics;
    }

    public final ImmutableLinkPredictionTrainPipelineResult withModel(Model<Classifier.ClassifierData, LinkPredictionTrainConfig, LinkPredictionModelInfo> value) {
        if (this.model == value) {
            return this;
        }
        Model<Classifier.ClassifierData, LinkPredictionTrainConfig, LinkPredictionModelInfo> newValue = Objects.requireNonNull(value, "model");
        return new ImmutableLinkPredictionTrainPipelineResult(this, newValue, this.trainingStatistics);
    }

    public final ImmutableLinkPredictionTrainPipelineResult withTrainingStatistics(TrainingStatistics value) {
        if (this.trainingStatistics == value) {
            return this;
        }
        TrainingStatistics newValue = Objects.requireNonNull(value, "trainingStatistics");
        return new ImmutableLinkPredictionTrainPipelineResult(this, this.model, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLinkPredictionTrainPipelineResult && this.equalTo((ImmutableLinkPredictionTrainPipelineResult)another);
    }

    private boolean equalTo(ImmutableLinkPredictionTrainPipelineResult another) {
        return this.model.equals(another.model) && this.trainingStatistics.equals(another.trainingStatistics);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.model.hashCode();
        h += (h << 5) + this.trainingStatistics.hashCode();
        return h;
    }

    public String toString() {
        return "LinkPredictionTrainPipelineResult{model=" + this.model + ", trainingStatistics=" + this.trainingStatistics + "}";
    }

    public static LinkPredictionTrainPipelineExecutor.LinkPredictionTrainPipelineResult of(Model<Classifier.ClassifierData, LinkPredictionTrainConfig, LinkPredictionModelInfo> model, TrainingStatistics trainingStatistics) {
        return new ImmutableLinkPredictionTrainPipelineResult(model, trainingStatistics);
    }

    public static LinkPredictionTrainPipelineExecutor.LinkPredictionTrainPipelineResult copyOf(LinkPredictionTrainPipelineExecutor.LinkPredictionTrainPipelineResult instance) {
        if (instance instanceof ImmutableLinkPredictionTrainPipelineResult) {
            return (ImmutableLinkPredictionTrainPipelineResult)instance;
        }
        return ImmutableLinkPredictionTrainPipelineResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="LinkPredictionTrainPipelineExecutor.LinkPredictionTrainPipelineResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_MODEL = 1L;
        private static final long INIT_BIT_TRAINING_STATISTICS = 2L;
        private long initBits = 3L;
        @Nullable
        private Model<Classifier.ClassifierData, LinkPredictionTrainConfig, LinkPredictionModelInfo> model;
        @Nullable
        private TrainingStatistics trainingStatistics;

        private Builder() {
        }

        public final Builder from(LinkPredictionTrainPipelineExecutor.LinkPredictionTrainPipelineResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.model((Model<Classifier.ClassifierData, LinkPredictionTrainConfig, LinkPredictionModelInfo>)instance.model());
            this.trainingStatistics(instance.trainingStatistics());
            return this;
        }

        public final Builder model(Model<Classifier.ClassifierData, LinkPredictionTrainConfig, LinkPredictionModelInfo> model) {
            this.model = Objects.requireNonNull(model, "model");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder trainingStatistics(TrainingStatistics trainingStatistics) {
            this.trainingStatistics = Objects.requireNonNull(trainingStatistics, "trainingStatistics");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder clear() {
            this.initBits = 3L;
            this.model = null;
            this.trainingStatistics = null;
            return this;
        }

        public LinkPredictionTrainPipelineExecutor.LinkPredictionTrainPipelineResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableLinkPredictionTrainPipelineResult(null, this.model, this.trainingStatistics);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("model");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("trainingStatistics");
            }
            return "Cannot build LinkPredictionTrainPipelineResult, some of required attributes are not set " + attributes;
        }
    }
}

