/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline.linkPipeline.train;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.core.utils.paged.HugeIntArray;
import org.neo4j.gds.ml.models.Features;
import org.neo4j.gds.ml.pipeline.linkPipeline.train.FeaturesAndLabels;

@ParametersAreNonnullByDefault
@Generated(from="FeaturesAndLabels", generator="Immutables")
@Immutable
public final class ImmutableFeaturesAndLabels
implements FeaturesAndLabels {
    private final Features features;
    private final HugeIntArray labels;

    private ImmutableFeaturesAndLabels(Features features, HugeIntArray labels) {
        this.features = Objects.requireNonNull(features, "features");
        this.labels = Objects.requireNonNull(labels, "labels");
    }

    private ImmutableFeaturesAndLabels(ImmutableFeaturesAndLabels original, Features features, HugeIntArray labels) {
        this.features = features;
        this.labels = labels;
    }

    @Override
    public Features features() {
        return this.features;
    }

    @Override
    public HugeIntArray labels() {
        return this.labels;
    }

    public final ImmutableFeaturesAndLabels withFeatures(Features value) {
        if (this.features == value) {
            return this;
        }
        Features newValue = Objects.requireNonNull(value, "features");
        return new ImmutableFeaturesAndLabels(this, newValue, this.labels);
    }

    public final ImmutableFeaturesAndLabels withLabels(HugeIntArray value) {
        if (this.labels == value) {
            return this;
        }
        HugeIntArray newValue = Objects.requireNonNull(value, "labels");
        return new ImmutableFeaturesAndLabels(this, this.features, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFeaturesAndLabels && this.equalTo((ImmutableFeaturesAndLabels)another);
    }

    private boolean equalTo(ImmutableFeaturesAndLabels another) {
        return this.features.equals(another.features) && this.labels.equals(another.labels);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.features.hashCode();
        h += (h << 5) + this.labels.hashCode();
        return h;
    }

    public String toString() {
        return "FeaturesAndLabels{features=" + this.features + ", labels=" + this.labels + "}";
    }

    public static FeaturesAndLabels of(Features features, HugeIntArray labels) {
        return new ImmutableFeaturesAndLabels(features, labels);
    }

    static FeaturesAndLabels copyOf(FeaturesAndLabels instance) {
        if (instance instanceof ImmutableFeaturesAndLabels) {
            return (ImmutableFeaturesAndLabels)instance;
        }
        return ImmutableFeaturesAndLabels.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="FeaturesAndLabels", generator="Immutables")
    @NotThreadSafe
    static final class Builder {
        private static final long INIT_BIT_FEATURES = 1L;
        private static final long INIT_BIT_LABELS = 2L;
        private long initBits = 3L;
        @Nullable
        private Features features;
        @Nullable
        private HugeIntArray labels;

        private Builder() {
        }

        public final Builder from(ImmutableFeaturesAndLabels instance) {
            return this.from((FeaturesAndLabels)instance);
        }

        final Builder from(FeaturesAndLabels instance) {
            Objects.requireNonNull(instance, "instance");
            this.features(instance.features());
            this.labels(instance.labels());
            return this;
        }

        public final Builder features(Features features) {
            this.features = Objects.requireNonNull(features, "features");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder labels(HugeIntArray labels) {
            this.labels = Objects.requireNonNull(labels, "labels");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder clear() {
            this.initBits = 3L;
            this.features = null;
            this.labels = null;
            return this;
        }

        public FeaturesAndLabels build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFeaturesAndLabels(null, this.features, this.labels);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("features");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("labels");
            }
            return "Cannot build FeaturesAndLabels, some of required attributes are not set " + attributes;
        }
    }
}

