/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline.linkPipeline.linkfunctions;

import java.util.Arrays;
import java.util.Collection;
import org.neo4j.gds.ml.pipeline.FeatureStepUtil;
import org.neo4j.gds.ml.pipeline.linkPipeline.LinkFeatureAppender;

class UnionLinkFeatureAppender
implements LinkFeatureAppender {
    private final LinkFeatureAppender[] appenderPerProperty;
    private final String featureStepName;
    private final Collection<String> inputNodeProperties;
    private final int dimension;

    UnionLinkFeatureAppender(LinkFeatureAppender[] appenderPerProperty, String featureStepName, Collection<String> inputNodeProperties) {
        this.appenderPerProperty = appenderPerProperty;
        this.featureStepName = featureStepName;
        this.inputNodeProperties = inputNodeProperties;
        this.dimension = Arrays.stream(appenderPerProperty).mapToInt(LinkFeatureAppender::dimension).sum();
    }

    @Override
    public void appendFeatures(long source, long target, double[] linkFeatures, int offset) {
        int localOffset = offset;
        for (LinkFeatureAppender linkFeatureAppender : this.appenderPerProperty) {
            linkFeatureAppender.appendFeatures(source, target, linkFeatures, localOffset);
            localOffset += linkFeatureAppender.dimension();
        }
        FeatureStepUtil.validateComputedFeatures(linkFeatures, offset, localOffset, () -> FeatureStepUtil.throwNanError(this.featureStepName, this.inputNodeProperties, source, target));
    }

    @Override
    public int dimension() {
        return this.dimension;
    }
}

