/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline.linkPipeline.linkfunctions;

import com.carrotsearch.hppc.predicates.LongLongPredicate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.properties.nodes.NodePropertyContainer;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.ml.pipeline.linkPipeline.LinkFeatureAppender;
import org.neo4j.gds.ml.pipeline.linkPipeline.LinkFeatureStep;
import org.neo4j.gds.ml.pipeline.linkPipeline.LinkFeatureStepFactory;
import org.neo4j.gds.utils.StringFormatting;

public class SameCategoryStep
implements LinkFeatureStep {
    private final List<String> nodeProperties;

    public SameCategoryStep(List<String> nodeProperties) {
        this.nodeProperties = nodeProperties;
    }

    @Override
    public List<String> inputNodeProperties() {
        return this.nodeProperties;
    }

    @Override
    public String name() {
        return LinkFeatureStepFactory.SAME_CATEGORY.name();
    }

    @Override
    public Map<String, Object> configuration() {
        return Map.of("nodeProperty", this.nodeProperties);
    }

    @Override
    public LinkFeatureAppender linkFeatureAppender(Graph graph) {
        final ArrayList<LongLongPredicate> isSamePredicates = new ArrayList<LongLongPredicate>();
        for (String nodeProperty : this.nodeProperties) {
            isSamePredicates.add(this.sameCategoryPredicate((NodePropertyContainer)graph, nodeProperty));
        }
        return new LinkFeatureAppender(){

            @Override
            public void appendFeatures(long source, long target, double[] linkFeatures, int offset) {
                int localOffset = offset;
                for (LongLongPredicate predicate : isSamePredicates) {
                    linkFeatures[localOffset++] = predicate.apply(source, target) ? 1.0 : 0.0;
                }
            }

            @Override
            public int dimension() {
                return SameCategoryStep.this.nodeProperties.size();
            }
        };
    }

    private LongLongPredicate sameCategoryPredicate(NodePropertyContainer graph, String nodeProperty) {
        NodePropertyValues propertyValues = graph.nodeProperties(nodeProperty);
        switch (propertyValues.valueType()) {
            case LONG: {
                return (source, target) -> propertyValues.longValue(source) == propertyValues.longValue(target);
            }
            case DOUBLE: {
                return (source, target) -> propertyValues.doubleValue(source) == propertyValues.doubleValue(target);
            }
        }
        throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"%s only supports combining numeric properties, but got node property `%s` of type %s.", (Object[])new Object[]{this.name(), nodeProperty, propertyValues.valueType()}));
    }
}

