/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline.linkPipeline.linkfunctions;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.immutables.value.Value;
import org.neo4j.gds.annotation.Configuration;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.gds.utils.StringJoining;

@Configuration
public interface LinkFeatureStepConfiguration {
    @Configuration.ConvertWith(method="fromObject")
    public List<String> nodeProperties();

    public static List<String> fromObject(Object nodeProperties) {
        if (nodeProperties instanceof List) {
            List nodePropertiesList = (List)nodeProperties;
            if (nodePropertiesList.isEmpty()) {
                throw new IllegalArgumentException("`nodeProperties` must be non-empty.");
            }
            List invalidProperties = nodePropertiesList.stream().filter(property -> !(property instanceof String) || ((String)property).isBlank()).map(Object::toString).collect(Collectors.toList());
            if (!invalidProperties.isEmpty()) {
                throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Invalid property names defined in `nodeProperties`: %s. Expecting a String with at least one non-white space character.", (Object[])new Object[]{StringJoining.join(invalidProperties)}));
            }
        } else {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"The value of `nodeProperties` must be of type `List` but was `%s`.", (Object[])new Object[]{nodeProperties.getClass().getSimpleName()}));
        }
        return (List)nodeProperties;
    }

    @Configuration.CollectKeys
    @Value.Auxiliary
    @Value.Default
    @Value.Parameter(value=false)
    default public Collection<String> configKeys() {
        return Collections.emptyList();
    }
}

