/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline.linkPipeline.linkfunctions;

import java.util.List;
import java.util.Map;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.ml.pipeline.linkPipeline.LinkFeatureAppender;
import org.neo4j.gds.ml.pipeline.linkPipeline.LinkFeatureStep;
import org.neo4j.gds.ml.pipeline.linkPipeline.LinkFeatureStepFactory;
import org.neo4j.gds.ml.pipeline.linkPipeline.linkfunctions.AbstractLinkFeatureAppenderFactory;
import org.neo4j.gds.ml.pipeline.linkPipeline.linkfunctions.SinglePropertyFeatureAppender;
import org.neo4j.gds.ml.pipeline.linkPipeline.linkfunctions.UnionLinkFeatureAppender;

public class HadamardFeatureStep
implements LinkFeatureStep {
    private final List<String> nodeProperties;

    public HadamardFeatureStep(List<String> nodeProperties) {
        this.nodeProperties = nodeProperties;
    }

    @Override
    public LinkFeatureAppender linkFeatureAppender(Graph graph) {
        LinkFeatureAppender[] appenderPerProperty = new HadamardFeatureAppenderFactory().createAppenders(graph, this.nodeProperties);
        return new UnionLinkFeatureAppender(appenderPerProperty, this.name(), this.nodeProperties);
    }

    @Override
    public List<String> inputNodeProperties() {
        return this.nodeProperties;
    }

    @Override
    public Map<String, Object> configuration() {
        return Map.of("nodeProperties", this.nodeProperties);
    }

    @Override
    public String name() {
        return LinkFeatureStepFactory.HADAMARD.name();
    }

    private static class HadamardFeatureAppenderFactory
    extends AbstractLinkFeatureAppenderFactory {
        private HadamardFeatureAppenderFactory() {
        }

        @Override
        protected LinkFeatureAppender doubleArrayAppender(NodePropertyValues props, int dimension) {
            return new HadamardDoubleArrayFeatureAppender(props, dimension);
        }

        @Override
        protected LinkFeatureAppender floatArrayAppender(NodePropertyValues props, int dimension) {
            return new HadamardFloatArrayFeatureAppender(props, dimension);
        }

        @Override
        protected LinkFeatureAppender longArrayAppender(NodePropertyValues props, int dimension) {
            return new HadamardLongArrayFeatureAppender(props, dimension);
        }

        @Override
        protected LinkFeatureAppender longAppender(NodePropertyValues props, int dimension) {
            return new HadamardLongFeatureAppender(props, dimension);
        }

        @Override
        protected LinkFeatureAppender doubleAppender(NodePropertyValues props, int dimension) {
            return new HadamardDoubleFeatureAppender(props, dimension);
        }

        private static class HadamardDoubleFeatureAppender
        extends SinglePropertyFeatureAppender {
            HadamardDoubleFeatureAppender(NodePropertyValues props, int dimension) {
                super(props, dimension);
            }

            @Override
            public void appendFeatures(long source, long target, double[] linkFeatures, int offset) {
                linkFeatures[offset] = this.props.doubleValue(source) * this.props.doubleValue(target);
            }
        }

        private static class HadamardLongFeatureAppender
        extends SinglePropertyFeatureAppender {
            HadamardLongFeatureAppender(NodePropertyValues props, int dimension) {
                super(props, dimension);
            }

            @Override
            public void appendFeatures(long source, long target, double[] linkFeatures, int offset) {
                linkFeatures[offset] = this.props.longValue(source) * this.props.longValue(target);
            }
        }

        private static class HadamardLongArrayFeatureAppender
        extends SinglePropertyFeatureAppender {
            HadamardLongArrayFeatureAppender(NodePropertyValues props, int dimension) {
                super(props, dimension);
            }

            @Override
            public void appendFeatures(long source, long target, double[] linkFeatures, int offset) {
                long[] sourceArrayPropValues = this.props.longArrayValue(source);
                long[] targetArrayPropValues = this.props.longArrayValue(target);
                assert (sourceArrayPropValues.length == targetArrayPropValues.length);
                for (int i = 0; i < sourceArrayPropValues.length; ++i) {
                    linkFeatures[offset++] = sourceArrayPropValues[i] * targetArrayPropValues[i];
                }
            }
        }

        private static class HadamardFloatArrayFeatureAppender
        extends SinglePropertyFeatureAppender {
            HadamardFloatArrayFeatureAppender(NodePropertyValues props, int dimension) {
                super(props, dimension);
            }

            @Override
            public void appendFeatures(long source, long target, double[] linkFeatures, int offset) {
                float[] sourceArrayPropValues = this.props.floatArrayValue(source);
                float[] targetArrayPropValues = this.props.floatArrayValue(target);
                assert (sourceArrayPropValues.length == targetArrayPropValues.length);
                for (int i = 0; i < sourceArrayPropValues.length; ++i) {
                    linkFeatures[offset++] = sourceArrayPropValues[i] * targetArrayPropValues[i];
                }
            }
        }

        private static class HadamardDoubleArrayFeatureAppender
        extends SinglePropertyFeatureAppender {
            HadamardDoubleArrayFeatureAppender(NodePropertyValues props, int dimension) {
                super(props, dimension);
            }

            @Override
            public void appendFeatures(long source, long target, double[] linkFeatures, int offset) {
                double[] sourceArrayPropValues = this.props.doubleArrayValue(source);
                double[] targetArrayPropValues = this.props.doubleArrayValue(target);
                assert (sourceArrayPropValues.length == targetArrayPropValues.length);
                for (int i = 0; i < sourceArrayPropValues.length; ++i) {
                    linkFeatures[offset++] = sourceArrayPropValues[i] * targetArrayPropValues[i];
                }
            }
        }
    }
}

