/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline.linkPipeline;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.concurrency.RunWithConcurrency;
import org.neo4j.gds.core.utils.TerminationFlag;
import org.neo4j.gds.core.utils.paged.HugeObjectArray;
import org.neo4j.gds.core.utils.partition.DegreePartition;
import org.neo4j.gds.core.utils.partition.PartitionUtils;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.ml.models.Features;
import org.neo4j.gds.ml.models.FeaturesFactory;
import org.neo4j.gds.ml.pipeline.linkPipeline.BatchLinkFeatureExtractor;
import org.neo4j.gds.ml.pipeline.linkPipeline.LinkFeatureAppender;
import org.neo4j.gds.ml.pipeline.linkPipeline.LinkFeatureStep;

public final class LinkFeatureExtractor {
    private final List<LinkFeatureAppender> linkFeatureAppenders;
    private final int featureDimension;
    private final boolean isSymmetric;

    private LinkFeatureExtractor(List<LinkFeatureAppender> linkFeatureAppenders) {
        this.linkFeatureAppenders = linkFeatureAppenders;
        this.featureDimension = linkFeatureAppenders.stream().mapToInt(LinkFeatureAppender::dimension).sum();
        this.isSymmetric = linkFeatureAppenders.stream().allMatch(LinkFeatureAppender::isSymmetric);
    }

    public static LinkFeatureExtractor of(Graph graph, List<LinkFeatureStep> linkFeatureSteps) {
        List<LinkFeatureAppender> linkFeatureProducers = linkFeatureSteps.stream().map(step -> step.linkFeatureAppender(graph)).collect(Collectors.toList());
        return new LinkFeatureExtractor(linkFeatureProducers);
    }

    public static Features extractFeatures(Graph graph, List<LinkFeatureStep> linkFeatureSteps, int concurrency, ProgressTracker progressTracker, TerminationFlag terminationFlag) {
        LinkFeatureExtractor extractor = LinkFeatureExtractor.of(graph, linkFeatureSteps);
        HugeObjectArray linkFeatures = HugeObjectArray.newArray(double[].class, (long)graph.relationshipCount());
        List partitions = PartitionUtils.degreePartition((Graph)graph, (int)concurrency, Function.identity(), Optional.of(100));
        ArrayList<BatchLinkFeatureExtractor> linkFeatureWriters = new ArrayList<BatchLinkFeatureExtractor>();
        long relationshipOffset = 0L;
        for (DegreePartition partition : partitions) {
            linkFeatureWriters.add(new BatchLinkFeatureExtractor(extractor, partition, graph.concurrentCopy(), relationshipOffset, (HugeObjectArray<double[]>)linkFeatures, progressTracker));
            relationshipOffset += partition.totalDegree();
        }
        RunWithConcurrency.builder().concurrency(concurrency).tasks(linkFeatureWriters).terminationFlag(terminationFlag).run();
        return FeaturesFactory.wrap((HugeObjectArray)linkFeatures);
    }

    public int featureDimension() {
        return this.featureDimension;
    }

    public double[] extractFeatures(long source, long target) {
        double[] featuresForLink = new double[this.featureDimension];
        int featureOffset = 0;
        for (LinkFeatureAppender featureProducer : this.linkFeatureAppenders) {
            featureProducer.appendFeatures(source, target, featuresForLink, featureOffset);
            featureOffset += featureProducer.dimension();
        }
        return featuresForLink;
    }

    public boolean isSymmetric() {
        return this.isSymmetric;
    }
}

