/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline;

import java.util.Set;
import org.neo4j.gds.Algorithm;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.api.schema.GraphSchema;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.core.model.CatalogModelContainer;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.ml.pipeline.FeatureStep;
import org.neo4j.gds.ml.pipeline.PipelineTrainer;
import org.neo4j.gds.ml.pipeline.ResultToModelConverter;
import org.neo4j.gds.ml.pipeline.TrainingPipeline;
import org.neo4j.gds.model.ModelConfig;

public abstract class PipelineTrainAlgorithm<RESULT, MODEL_RESULT extends CatalogModelContainer<?, CONFIG, ?>, CONFIG extends AlgoBaseConfig & ModelConfig, FEATURE_STEP extends FeatureStep>
extends Algorithm<MODEL_RESULT> {
    protected final TrainingPipeline<FEATURE_STEP> pipeline;
    protected final GraphStore graphStore;
    protected final CONFIG config;
    private final PipelineTrainer<RESULT> pipelineTrainer;
    private final ResultToModelConverter<MODEL_RESULT, RESULT> toCatalogModelConverter;

    public PipelineTrainAlgorithm(PipelineTrainer<RESULT> pipelineTrainer, TrainingPipeline<FEATURE_STEP> pipeline, ResultToModelConverter<MODEL_RESULT, RESULT> toCatalogModelConverter, GraphStore graphStore, CONFIG config, ProgressTracker progressTracker) {
        super(progressTracker);
        this.pipelineTrainer = pipelineTrainer;
        this.pipeline = pipeline;
        this.toCatalogModelConverter = toCatalogModelConverter;
        this.graphStore = graphStore;
        this.config = config;
    }

    public MODEL_RESULT compute() {
        this.pipelineTrainer.setTerminationFlag(this.terminationFlag);
        this.pipeline.validateTrainingParameterSpace();
        this.pipeline.validateBeforeExecution(this.graphStore, this.config.nodeLabelIdentifiers(this.graphStore));
        GraphSchema originalSchema = this.graphStore.schema().filterNodeLabels(Set.copyOf(this.config.nodeLabelIdentifiers(this.graphStore))).filterRelationshipTypes(Set.copyOf(this.config.internalRelationshipTypes(this.graphStore)));
        RESULT pipelineTrainResult = this.pipelineTrainer.run();
        return (MODEL_RESULT)((CatalogModelContainer)this.toCatalogModelConverter.toModel(pipelineTrainResult, originalSchema));
    }

    public void release() {
    }
}

