/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline;

import java.util.Map;
import java.util.Set;
import org.neo4j.gds.Algorithm;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.api.schema.GraphSchema;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.GraphNameConfig;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.ml.pipeline.NodePropertyStepExecutor;
import org.neo4j.gds.ml.pipeline.Pipeline;
import org.neo4j.gds.ml.pipeline.PipelineGraphFilter;

public abstract class PipelineExecutor<PIPELINE_CONFIG extends AlgoBaseConfig & GraphNameConfig, PIPELINE extends Pipeline<?>, RESULT>
extends Algorithm<RESULT> {
    protected final PIPELINE pipeline;
    protected final PIPELINE_CONFIG config;
    protected final ExecutionContext executionContext;
    protected final GraphStore graphStore;
    protected final GraphSchema schemaBeforeSteps;

    protected PipelineExecutor(PIPELINE pipeline, PIPELINE_CONFIG config, ExecutionContext executionContext, GraphStore graphStore, ProgressTracker progressTracker) {
        super(progressTracker);
        this.pipeline = pipeline;
        this.config = config;
        this.executionContext = executionContext;
        this.graphStore = graphStore;
        this.schemaBeforeSteps = graphStore.schema().filterNodeLabels(Set.copyOf(config.nodeLabelIdentifiers(graphStore))).filterRelationshipTypes(Set.copyOf(config.internalRelationshipTypes(graphStore)));
    }

    public abstract Map<DatasetSplits, PipelineGraphFilter> generateDatasetSplitGraphFilters();

    public abstract void splitDatasets();

    protected abstract RESULT execute(Map<DatasetSplits, PipelineGraphFilter> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RESULT compute() {
        this.progressTracker.beginSubTask();
        Map<DatasetSplits, PipelineGraphFilter> dataSplitGraphFilters = this.generateDatasetSplitGraphFilters();
        PipelineGraphFilter featureInputGraphFilter = dataSplitGraphFilters.get((Object)DatasetSplits.FEATURE_INPUT);
        this.pipeline.validateBeforeExecution(this.graphStore, featureInputGraphFilter.nodeLabels());
        NodePropertyStepExecutor<PIPELINE_CONFIG> nodePropertyStepExecutor = NodePropertyStepExecutor.of(this.executionContext, this.graphStore, this.config, featureInputGraphFilter.nodeLabels(), featureInputGraphFilter.relationshipTypes(), this.getAvailableRelTypesForNodePropertySteps(), this.progressTracker);
        nodePropertyStepExecutor.validNodePropertyStepsContextConfigs(this.pipeline.nodePropertySteps());
        this.splitDatasets();
        try {
            nodePropertyStepExecutor.executeNodePropertySteps(this.pipeline.nodePropertySteps());
            this.pipeline.validateFeatureProperties(this.graphStore, this.config.nodeLabelIdentifiers(this.graphStore));
            RESULT result = this.execute(dataSplitGraphFilters);
            this.progressTracker.endSubTask();
            RESULT RESULT = result;
            return RESULT;
        }
        finally {
            nodePropertyStepExecutor.cleanupIntermediateProperties(this.pipeline.nodePropertySteps());
            this.additionalGraphStoreCleanup(dataSplitGraphFilters);
        }
    }

    protected abstract Set<RelationshipType> getAvailableRelTypesForNodePropertySteps();

    public void release() {
    }

    protected void additionalGraphStoreCleanup(Map<DatasetSplits, PipelineGraphFilter> datasets) {
    }

    public static enum DatasetSplits {
        TRAIN,
        TEST,
        TEST_COMPLEMENT,
        FEATURE_INPUT;

    }
}

