/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.configuration.DefaultsConfiguration;
import org.neo4j.gds.configuration.LimitsConfiguration;
import org.neo4j.gds.core.Username;
import org.neo4j.gds.executor.AlgoConfigParser;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallableFinder;
import org.neo4j.gds.executor.NewConfigFunction;
import org.neo4j.gds.ml.pipeline.NodePropertyStep;
import org.neo4j.gds.ml.pipeline.NodePropertyStepContextConfig;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.gds.utils.StringJoining;

public final class NodePropertyStepFactory {
    private static final List<String> RESERVED_CONFIG_KEYS = List.of("nodeLabels", "relationshipTypes");

    private NodePropertyStepFactory() {
    }

    public static NodePropertyStep createNodePropertyStep(String taskName, Map<String, Object> configMap) {
        GdsCallableFinder.GdsCallableDefinition gdsCallableDefinition = NodePropertyStepFactory.getGdsCallableDefinition(taskName);
        HashMap<String, Object> procConfigMap = new HashMap<String, Object>(configMap);
        Object contextNodeLabels = procConfigMap.remove("contextNodeLabels");
        Object contextRelationshipTypes = procConfigMap.remove("contextRelationshipTypes");
        HashMap<String, Object> contextConfigMap = new HashMap<String, Object>();
        if (contextNodeLabels != null) {
            contextConfigMap.put("contextNodeLabels", contextNodeLabels);
        }
        if (contextRelationshipTypes != null) {
            contextConfigMap.put("contextRelationshipTypes", contextRelationshipTypes);
        }
        NodePropertyStepContextConfig contextConfig = NodePropertyStepContextConfig.of(contextConfigMap);
        return NodePropertyStepFactory.createNodePropertyStepFromCallableDefinition(procConfigMap, gdsCallableDefinition, contextConfig.contextNodeLabels(), contextConfig.contextRelationshipTypes());
    }

    public static NodePropertyStep createNodePropertyStep(String taskName, Map<String, Object> procConfigMap, List<String> contextNodeLabels, List<String> contextRelationshipTypes) {
        return NodePropertyStepFactory.createNodePropertyStepFromCallableDefinition(procConfigMap, NodePropertyStepFactory.getGdsCallableDefinition(taskName), contextNodeLabels, contextRelationshipTypes);
    }

    private static NodePropertyStep createNodePropertyStepFromCallableDefinition(Map<String, Object> procConfigMap, GdsCallableFinder.GdsCallableDefinition gdsCallableDefinition, List<String> contextNodeLabels, List<String> contextRelationshipTypes) {
        NodePropertyStepFactory.validateReservedConfigKeys(procConfigMap);
        NodePropertyStepFactory.tryParsingConfig(gdsCallableDefinition, procConfigMap);
        return new NodePropertyStep(gdsCallableDefinition, procConfigMap, contextNodeLabels, contextRelationshipTypes);
    }

    public static GdsCallableFinder.GdsCallableDefinition getGdsCallableDefinition(String taskName) {
        String normalizedName = NodePropertyStepFactory.normalizeName(taskName);
        GdsCallableFinder.GdsCallableDefinition gdsCallableDefinition = (GdsCallableFinder.GdsCallableDefinition)GdsCallableFinder.findByName((String)normalizedName).orElseThrow(() -> new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Could not find a procedure called %s", (Object[])new Object[]{normalizedName})));
        if (gdsCallableDefinition.executionMode() != ExecutionMode.MUTATE_NODE_PROPERTY) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"The procedure %s does not mutate node properties and is thus not allowed as node property step", (Object[])new Object[]{normalizedName}));
        }
        return gdsCallableDefinition;
    }

    private static AlgoBaseConfig tryParsingConfig(GdsCallableFinder.GdsCallableDefinition callableDefinition, Map<String, Object> configuration) {
        NewConfigFunction newConfigFunction = callableDefinition.algorithmSpec().newConfigFunction();
        DefaultsConfiguration defaults = DefaultsConfiguration.Instance;
        LimitsConfiguration limits = LimitsConfiguration.Instance;
        return new AlgoConfigParser(Username.EMPTY_USERNAME.username(), newConfigFunction, defaults, limits).processInput(configuration);
    }

    private static void validateReservedConfigKeys(Map<String, Object> procedureConfig) {
        if (RESERVED_CONFIG_KEYS.stream().anyMatch(procedureConfig::containsKey)) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Cannot configure %s for an individual node property step.", (Object[])new Object[]{StringJoining.join(RESERVED_CONFIG_KEYS)}));
        }
    }

    private static String normalizeName(String input) {
        input = !(input = input.toLowerCase(Locale.ROOT)).startsWith("gds.") ? StringFormatting.formatWithLocale((String)"gds.%s", (Object[])new Object[]{input}) : input;
        input = !input.endsWith(".mutate") ? StringFormatting.formatWithLocale((String)"%s.mutate", (Object[])new Object[]{input}) : input;
        return input;
    }
}

