/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.ElementTypeValidator;
import org.neo4j.gds.config.GraphNameConfig;
import org.neo4j.gds.core.model.ModelCatalog;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.mem.MemoryEstimations;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.Task;
import org.neo4j.gds.core.utils.progress.tasks.Tasks;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.ml.pipeline.ExecutableNodePropertyStep;
import org.neo4j.gds.utils.StringFormatting;

public class NodePropertyStepExecutor<PIPELINE_CONFIG extends AlgoBaseConfig & GraphNameConfig> {
    private final ExecutionContext executionContext;
    private final PIPELINE_CONFIG config;
    private final GraphStore graphStore;
    private final Collection<NodeLabel> nodeLabels;
    private final Collection<RelationshipType> relTypes;
    private final Set<RelationshipType> availableRelationshipTypesForNodeProperties;
    private final ProgressTracker progressTracker;

    NodePropertyStepExecutor(ExecutionContext executionContext, PIPELINE_CONFIG config, GraphStore graphStore, Collection<NodeLabel> nodeLabels, Collection<RelationshipType> relationshipTypes, Set<RelationshipType> availableRelationshipTypesForNodeProperties, ProgressTracker progressTracker) {
        this.executionContext = executionContext;
        this.config = config;
        this.graphStore = graphStore;
        this.nodeLabels = nodeLabels;
        this.relTypes = relationshipTypes;
        this.availableRelationshipTypesForNodeProperties = availableRelationshipTypesForNodeProperties;
        this.progressTracker = progressTracker;
    }

    public static MemoryEstimation estimateNodePropertySteps(ModelCatalog modelCatalog, String username, List<ExecutableNodePropertyStep> nodePropertySteps, List<String> nodeLabels, List<String> relationshipTypes) {
        List nodePropertyStepEstimations = nodePropertySteps.stream().map(step -> step.estimate(modelCatalog, username, nodeLabels, relationshipTypes)).collect(Collectors.toList());
        return MemoryEstimations.maxEstimation((String)"NodeProperty Steps", nodePropertyStepEstimations);
    }

    public static Task tasks(List<ExecutableNodePropertyStep> nodePropertySteps, long featureInputSize) {
        long volumeEstimation = 10L * featureInputSize;
        return Tasks.task((String)"Execute node property steps", nodePropertySteps.stream().map(ExecutableNodePropertyStep::rootTaskName).map(taskName -> Tasks.leaf((String)taskName, (long)volumeEstimation)).collect(Collectors.toList()));
    }

    public void validNodePropertyStepsContextConfigs(List<ExecutableNodePropertyStep> steps) {
        for (ExecutableNodePropertyStep step : steps) {
            ElementTypeValidator.validate((GraphStore)this.graphStore, (Collection)ElementTypeValidator.resolve((GraphStore)this.graphStore, step.contextNodeLabels()), (String)StringFormatting.formatWithLocale((String)"contextNodeLabels for step `%s`", (Object[])new Object[]{step.procName()}));
            ElementTypeValidator.validateTypes((GraphStore)this.graphStore, (Collection)ElementTypeValidator.resolveTypes((GraphStore)this.graphStore, step.contextRelationshipTypes()), (String)StringFormatting.formatWithLocale((String)"contextRelationshipTypes for step `%s`", (Object[])new Object[]{step.procName()}));
        }
    }

    public void executeNodePropertySteps(List<ExecutableNodePropertyStep> steps) {
        this.progressTracker.beginSubTask("Execute node property steps");
        for (ExecutableNodePropertyStep step : steps) {
            this.progressTracker.beginSubTask();
            Set<NodeLabel> featureInputNodeLabels = step.featureInputNodeLabels(this.graphStore, this.nodeLabels);
            Set<RelationshipType> featureInputRelationshipTypes = step.featureInputRelationshipTypes(this.graphStore, this.relTypes, this.availableRelationshipTypesForNodeProperties);
            step.execute(this.executionContext, ((GraphNameConfig)this.config).graphName(), featureInputNodeLabels, featureInputRelationshipTypes);
            this.progressTracker.endSubTask();
        }
        this.progressTracker.endSubTask("Execute node property steps");
    }

    public void cleanupIntermediateProperties(List<ExecutableNodePropertyStep> steps) {
        steps.stream().map(ExecutableNodePropertyStep::mutateNodeProperty).forEach(arg_0 -> ((GraphStore)this.graphStore).removeNodeProperty(arg_0));
    }

    public static <CONFIG extends AlgoBaseConfig & GraphNameConfig> NodePropertyStepExecutor<CONFIG> of(ExecutionContext executionContext, GraphStore graphStore, CONFIG config, Collection<NodeLabel> nodeLabels, Collection<RelationshipType> relationshipTypes, Set<RelationshipType> availableRelationshipTypesForNodeProperty, ProgressTracker progressTracker) {
        return new NodePropertyStepExecutor<CONFIG>(executionContext, config, graphStore, nodeLabels, relationshipTypes, availableRelationshipTypesForNodeProperty, progressTracker);
    }
}

