/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.neo4j.gds.Algorithm;
import org.neo4j.gds.AlgorithmFactory;
import org.neo4j.gds.ElementIdentifier;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.configuration.DefaultsConfiguration;
import org.neo4j.gds.configuration.LimitsConfiguration;
import org.neo4j.gds.core.model.ModelCatalog;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.mem.MemoryEstimations;
import org.neo4j.gds.core.utils.mem.MemoryRange;
import org.neo4j.gds.exceptions.MemoryEstimationNotImplementedException;
import org.neo4j.gds.executor.AlgoConfigParser;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.ExecutorSpec;
import org.neo4j.gds.executor.GdsCallableFinder;
import org.neo4j.gds.executor.ProcedureExecutor;
import org.neo4j.gds.executor.ProcedureExecutorSpec;
import org.neo4j.gds.ml.pipeline.ExecutableNodePropertyStep;

public final class NodePropertyStep
implements ExecutableNodePropertyStep {
    private final GdsCallableFinder.GdsCallableDefinition callableDefinition;
    private final Map<String, Object> config;
    private final List<String> contextNodeLabels;
    private final List<String> contextRelationshipTypes;

    public NodePropertyStep(GdsCallableFinder.GdsCallableDefinition callableDefinition, Map<String, Object> config) {
        this(callableDefinition, config, List.of(), List.of());
    }

    public NodePropertyStep(GdsCallableFinder.GdsCallableDefinition callableDefinition, Map<String, Object> config, List<String> contextNodeLabels, List<String> contextRelationshipTypes) {
        this.callableDefinition = callableDefinition;
        this.config = config;
        this.contextNodeLabels = contextNodeLabels;
        this.contextRelationshipTypes = contextRelationshipTypes;
    }

    @Override
    public Map<String, Object> config() {
        return this.config;
    }

    @Override
    public List<String> contextNodeLabels() {
        return this.contextNodeLabels;
    }

    @Override
    public List<String> contextRelationshipTypes() {
        return this.contextRelationshipTypes;
    }

    @Override
    public String mutateNodeProperty() {
        return this.config().get("mutateProperty").toString();
    }

    @Override
    public String procName() {
        return this.callableDefinition.name();
    }

    @Override
    public String rootTaskName() {
        return this.callableDefinition.algorithmSpec().algorithmFactory().taskName();
    }

    @Override
    public MemoryEstimation estimate(ModelCatalog modelCatalog, String username, List<String> nodeLabels, List<String> relTypes) {
        AlgorithmSpec<Algorithm<Object>, Object, AlgoBaseConfig, Object, AlgorithmFactory<?, Algorithm<Object>, AlgoBaseConfig>> algoSpec = this.getAlgorithmSpec(modelCatalog);
        HashMap<String, Object> configCopy = new HashMap<String, Object>(this.config);
        configCopy.put("relationshipTypes", relTypes);
        configCopy.put("nodeLabels", nodeLabels);
        DefaultsConfiguration defaults = DefaultsConfiguration.Empty;
        LimitsConfiguration limits = LimitsConfiguration.Empty;
        AlgoBaseConfig algoConfig = new AlgoConfigParser(username, algoSpec.newConfigFunction(), defaults, limits).processInput(configCopy);
        try {
            algoSpec.algorithmFactory().memoryEstimation(algoConfig);
        }
        catch (MemoryEstimationNotImplementedException exception) {
            return MemoryEstimations.of((String)this.callableDefinition.name(), (MemoryRange)MemoryRange.of((long)0L));
        }
        return algoSpec.algorithmFactory().memoryEstimation(algoConfig);
    }

    @Override
    public void execute(ExecutionContext executionContext, String graphName, Collection<NodeLabel> nodeLabels, Collection<RelationshipType> relTypes) {
        HashMap<String, Object> configCopy = new HashMap<String, Object>(this.config);
        List nodeLabelStrings = nodeLabels.stream().map(ElementIdentifier::name).collect(Collectors.toList());
        List relTypeStrings = relTypes.stream().map(ElementIdentifier::name).collect(Collectors.toList());
        configCopy.put("nodeLabels", nodeLabelStrings);
        configCopy.put("relationshipTypes", relTypeStrings);
        AlgorithmSpec<Algorithm<Object>, Object, AlgoBaseConfig, Object, AlgorithmFactory<?, Algorithm<Object>, AlgoBaseConfig>> algorithmSpec = this.getAlgorithmSpec(executionContext.modelCatalog());
        new ProcedureExecutor(algorithmSpec, (ExecutorSpec)new ProcedureExecutorSpec(), executionContext).compute(graphName, configCopy, false, false);
    }

    private AlgorithmSpec<Algorithm<Object>, Object, AlgoBaseConfig, Object, AlgorithmFactory<?, Algorithm<Object>, AlgoBaseConfig>> getAlgorithmSpec(ModelCatalog modelCatalog) {
        return this.callableDefinition.algorithmSpec().withModelCatalog(modelCatalog);
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> configWithContext = new LinkedHashMap<String, Object>(this.config);
        configWithContext.put("contextNodeLabels", this.contextNodeLabels);
        configWithContext.put("contextRelationshipTypes", this.contextRelationshipTypes);
        return Map.of("name", this.procName(), "config", configWithContext);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodePropertyStep that = (NodePropertyStep)o;
        return Objects.equals(this.callableDefinition, that.callableDefinition) && Objects.equals(this.config, that.config);
    }

    public int hashCode() {
        return Objects.hash(this.callableDefinition, this.config);
    }
}

