/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline;

import java.util.Collection;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.gds.utils.StringJoining;

public final class FeatureStepUtil {
    private FeatureStepUtil() {
    }

    public static int propertyDimension(Graph graph, String nodeProperty) {
        return FeatureStepUtil.propertyDimension(graph.nodeProperties(nodeProperty), nodeProperty);
    }

    public static int propertyDimension(NodePropertyValues nodeProperties, String propertyName) {
        int dimension = 0;
        switch (nodeProperties.valueType()) {
            case LONG: 
            case DOUBLE: {
                dimension = 1;
                break;
            }
            case DOUBLE_ARRAY: 
            case FLOAT_ARRAY: {
                dimension = nodeProperties.doubleArrayValue(0L).length;
                break;
            }
            case LONG_ARRAY: {
                dimension = nodeProperties.longArrayValue(0L).length;
                break;
            }
            case UNKNOWN: {
                throw new IllegalStateException(StringFormatting.formatWithLocale((String)"Unknown ValueType %s", (Object[])new Object[]{propertyName}));
            }
        }
        return dimension;
    }

    public static void validateComputedFeatures(double[] linkFeatures, int startOffset, int endOffset, Runnable throwError) {
        for (int offset = startOffset; offset < endOffset; ++offset) {
            if (!Double.isNaN(linkFeatures[offset])) continue;
            throwError.run();
        }
    }

    public static void throwNanError(String featureStep, Collection<String> nodeProperties, long source, long target) {
        throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Encountered NaN when combining the nodeProperties %s for the node pair (%d, %d) when computing the %s feature vector. Either define a default value if its a stored property or check the nodePropertyStep.", (Object[])new Object[]{StringJoining.join(nodeProperties), source, target, featureStep}));
    }
}

