/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.core.CypherMapAccess;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.ml.pipeline.AutoTuningConfig;

public final class AutoTuningConfigImpl
implements AutoTuningConfig {
    private int maxTrials;

    public AutoTuningConfigImpl(@NotNull CypherMapAccess config) {
        ArrayList<IllegalArgumentException> errors = new ArrayList<IllegalArgumentException>();
        try {
            this.maxTrials = config.getInt("maxTrials", AutoTuningConfig.super.maxTrials());
            CypherMapAccess.validateIntegerRange((String)"maxTrials", (int)this.maxTrials, (int)1, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        if (!errors.isEmpty()) {
            if (errors.size() == 1) {
                throw (IllegalArgumentException)errors.get(0);
            }
            String combinedErrorMsg = errors.stream().map(Throwable::getMessage).collect(Collectors.joining(System.lineSeparator() + "\t\t\t\t", "Multiple errors in configuration arguments:" + System.lineSeparator() + "\t\t\t\t", ""));
            IllegalArgumentException combinedError = new IllegalArgumentException(combinedErrorMsg);
            errors.forEach(error -> combinedError.addSuppressed((Throwable)error));
            throw combinedError;
        }
    }

    @Override
    public int maxTrials() {
        return this.maxTrials;
    }

    @Override
    public Map<String, Object> toMap() {
        return Collections.singletonMap("maxTrials", this.maxTrials());
    }

    @Override
    public Collection<String> configKeys() {
        return Collections.singleton("maxTrials");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, Object> config = new HashMap<String, Object>();

        public static Builder from(AutoTuningConfig baseConfig) {
            Builder builder = new Builder();
            builder.maxTrials(baseConfig.maxTrials());
            return builder;
        }

        public Builder maxTrials(int maxTrials) {
            this.config.put("maxTrials", maxTrials);
            return this;
        }

        public AutoTuningConfig build() {
            CypherMapWrapper config = CypherMapWrapper.create(this.config);
            return new AutoTuningConfigImpl((CypherMapAccess)config);
        }
    }
}

