/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.neo4j.gds.annotation.Configuration;
import org.neo4j.gds.config.ToMapConvertible;
import org.neo4j.gds.core.CypherMapAccess;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.ml.pipeline.AutoTuningConfigImpl;

@Configuration
public interface AutoTuningConfig
extends ToMapConvertible {
    public static final int MAX_TRIALS = 10;
    public static final AutoTuningConfig DEFAULT_CONFIG = AutoTuningConfig.of(CypherMapWrapper.empty());

    @Configuration.IntegerRange(min=1)
    default public int maxTrials() {
        return 10;
    }

    @Configuration.ToMap
    public Map<String, Object> toMap();

    @Configuration.CollectKeys
    default public Collection<String> configKeys() {
        return Collections.emptyList();
    }

    public static AutoTuningConfig of(CypherMapWrapper config) {
        return new AutoTuningConfigImpl((CypherMapAccess)config);
    }
}

