/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.compat;

import java.io.OutputStream;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import org.neo4j.gds.compat.LogBuilders;
import org.neo4j.logging.Level;
import org.neo4j.logging.Log;

@Generated(from="LogBuilders.outputStreamLog", generator="Immutables")
public final class OutputStreamLogBuilder {
    private static final long INIT_BIT_OUTPUT_STREAM = 1L;
    private long initBits = 1L;
    private OutputStream outputStream;
    private Optional<Level> level = Optional.empty();
    private Optional<ZoneId> zoneId = Optional.empty();
    private Optional<String> category = Optional.empty();

    public OutputStreamLogBuilder(OutputStream outputStream) {
        this.outputStream(outputStream);
    }

    private final OutputStreamLogBuilder outputStream(OutputStream outputStream) {
        this.outputStream = Objects.requireNonNull(outputStream, "outputStream");
        this.initBits &= 0xFFFFFFFFFFFFFFFEL;
        return this;
    }

    public final OutputStreamLogBuilder level(Level level) {
        this.level = Optional.of(level);
        return this;
    }

    public final OutputStreamLogBuilder level(Optional<? extends Level> level) {
        this.level = Objects.requireNonNull(level, "level");
        return this;
    }

    public final OutputStreamLogBuilder zoneId(ZoneId zoneId) {
        this.zoneId = Optional.of(zoneId);
        return this;
    }

    public final OutputStreamLogBuilder zoneId(Optional<? extends ZoneId> zoneId) {
        this.zoneId = Objects.requireNonNull(zoneId, "zoneId");
        return this;
    }

    public final OutputStreamLogBuilder category(String category) {
        this.category = Optional.of(category);
        return this;
    }

    public final OutputStreamLogBuilder category(Optional<String> category) {
        this.category = Objects.requireNonNull(category, "category");
        return this;
    }

    public Log build() {
        this.checkRequiredAttributes();
        return LogBuilders.outputStreamLog(this.outputStream, this.level, this.zoneId, this.category);
    }

    private boolean outputStreamIsSet() {
        return (this.initBits & 1L) == 0L;
    }

    private void checkRequiredAttributes() {
        if (this.initBits != 0L) {
            throw new IllegalStateException(this.formatRequiredAttributesMessage());
        }
    }

    private String formatRequiredAttributesMessage() {
        ArrayList<String> attributes = new ArrayList<String>();
        if (!this.outputStreamIsSet()) {
            attributes.add("outputStream");
        }
        return "Cannot build outputStreamLog, some of required attributes are not set " + attributes;
    }
}

