/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.compat._54;

import org.neo4j.gds.compat.StoreScan;
import org.neo4j.internal.kernel.api.Cursor;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.internal.kernel.api.PartitionedScan;
import org.neo4j.kernel.api.KernelTransaction;

final class PartitionedStoreScan
implements StoreScan<NodeLabelIndexCursor> {
    private final PartitionedScan<NodeLabelIndexCursor> scan;

    PartitionedStoreScan(PartitionedScan<NodeLabelIndexCursor> scan) {
        this.scan = scan;
    }

    static int getNumberOfPartitions(long nodeCount, int batchSize) {
        int numberOfPartitions;
        if (nodeCount > 0L) {
            long partitions = (nodeCount - 1L) / (long)batchSize + 1L;
            if (partitions < 1L) {
                partitions = 1L;
            }
            numberOfPartitions = (int)Long.min(Integer.MAX_VALUE, partitions);
        } else {
            numberOfPartitions = 1;
        }
        return numberOfPartitions;
    }

    public boolean reserveBatch(NodeLabelIndexCursor cursor, KernelTransaction ktx) {
        return this.scan.reservePartition((Cursor)cursor, ktx.cursorContext(), ktx.securityContext().mode());
    }
}

