/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.api.schema;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.api.PropertyState;
import org.neo4j.gds.api.nodeproperties.ValueType;
import org.neo4j.gds.api.schema.GraphSchema;
import org.neo4j.gds.api.schema.NodeSchemaEntry;
import org.neo4j.gds.api.schema.PropertySchema;
import org.neo4j.gds.utils.StringFormatting;

public class MutableNodeSchemaEntry
implements NodeSchemaEntry {
    private final NodeLabel nodeLabel;
    private final Map<String, PropertySchema> properties;

    static MutableNodeSchemaEntry from(NodeSchemaEntry fromEntry) {
        return new MutableNodeSchemaEntry((NodeLabel)fromEntry.identifier(), new HashMap<String, PropertySchema>(fromEntry.properties()));
    }

    MutableNodeSchemaEntry(NodeLabel identifier) {
        this(identifier, new LinkedHashMap<String, PropertySchema>());
    }

    public MutableNodeSchemaEntry(NodeLabel nodeLabel, Map<String, PropertySchema> properties) {
        this.nodeLabel = nodeLabel;
        this.properties = properties;
    }

    @Override
    public NodeLabel identifier() {
        return this.nodeLabel;
    }

    @Override
    public Map<String, PropertySchema> properties() {
        return Map.copyOf(this.properties);
    }

    @Override
    public MutableNodeSchemaEntry union(MutableNodeSchemaEntry other) {
        if (!other.identifier().equals((Object)this.identifier())) {
            throw new UnsupportedOperationException(StringFormatting.formatWithLocale((String)"Cannot union node schema entries with different node labels %s and %s", (Object[])new Object[]{this.identifier(), other.identifier()}));
        }
        return new MutableNodeSchemaEntry(this.identifier(), this.unionProperties(other.properties));
    }

    @Override
    public Map<String, Object> toMap() {
        return this.properties.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, innerEntry -> GraphSchema.forPropertySchema((PropertySchema)innerEntry.getValue())));
    }

    public MutableNodeSchemaEntry addProperty(String propertyName, ValueType valueType) {
        return this.addProperty(propertyName, PropertySchema.of(propertyName, valueType, valueType.fallbackValue(), PropertyState.PERSISTENT));
    }

    public MutableNodeSchemaEntry addProperty(String propertyName, PropertySchema propertySchema) {
        this.properties.put(propertyName, propertySchema);
        return this;
    }

    public void removeProperty(String propertyName) {
        this.properties.remove(propertyName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MutableNodeSchemaEntry that = (MutableNodeSchemaEntry)o;
        if (!this.nodeLabel.equals((Object)that.nodeLabel)) {
            return false;
        }
        return this.properties.equals(that.properties);
    }

    public int hashCode() {
        int result = this.nodeLabel.hashCode();
        result = 31 * result + this.properties.hashCode();
        return result;
    }
}

