/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.api.schema;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.api.nodeproperties.ValueType;
import org.neo4j.gds.api.schema.MutableNodeSchemaEntry;
import org.neo4j.gds.api.schema.NodeSchema;
import org.neo4j.gds.api.schema.NodeSchemaEntry;
import org.neo4j.gds.api.schema.PropertySchema;

public final class MutableNodeSchema
implements NodeSchema {
    private final Map<NodeLabel, MutableNodeSchemaEntry> entries;

    public static MutableNodeSchema empty() {
        return new MutableNodeSchema(new LinkedHashMap<NodeLabel, MutableNodeSchemaEntry>());
    }

    private MutableNodeSchema(Map<NodeLabel, MutableNodeSchemaEntry> entries) {
        this.entries = entries;
    }

    public static MutableNodeSchema from(NodeSchema fromSchema) {
        MutableNodeSchema nodeSchema = MutableNodeSchema.empty();
        fromSchema.entries().forEach(fromEntry -> nodeSchema.set(MutableNodeSchemaEntry.from(fromEntry)));
        return nodeSchema;
    }

    @Override
    public Set<NodeLabel> availableLabels() {
        return this.entries.keySet();
    }

    @Override
    public boolean containsOnlyAllNodesLabel() {
        return this.availableLabels().size() == 1 && this.availableLabels().contains(NodeLabel.ALL_NODES);
    }

    @Override
    public MutableNodeSchema filter(Set<NodeLabel> labelsToKeep) {
        return new MutableNodeSchema(this.entries.entrySet().stream().filter((? super T e) -> labelsToKeep.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, entry -> MutableNodeSchemaEntry.from((NodeSchemaEntry)entry.getValue()))));
    }

    @Override
    public MutableNodeSchema union(NodeSchema other) {
        return new MutableNodeSchema(this.unionEntries(other));
    }

    @Override
    public Collection<MutableNodeSchemaEntry> entries() {
        return this.entries.values();
    }

    @Override
    public MutableNodeSchemaEntry get(NodeLabel identifier) {
        return this.entries.get(identifier);
    }

    public void set(MutableNodeSchemaEntry entry) {
        this.entries.put(entry.identifier(), entry);
    }

    public void remove(NodeLabel identifier) {
        this.entries.remove(identifier);
    }

    public MutableNodeSchemaEntry getOrCreateLabel(NodeLabel key) {
        return this.entries.computeIfAbsent(key, __ -> new MutableNodeSchemaEntry(key));
    }

    public MutableNodeSchema addLabel(NodeLabel nodeLabel) {
        this.getOrCreateLabel(nodeLabel);
        return this;
    }

    public MutableNodeSchema addLabel(NodeLabel nodeLabel, Map<String, PropertySchema> nodeProperties) {
        MutableNodeSchemaEntry nodeSchemaEntry = this.getOrCreateLabel(nodeLabel);
        nodeProperties.forEach(nodeSchemaEntry::addProperty);
        return this;
    }

    public MutableNodeSchema addProperty(NodeLabel nodeLabel, String propertyName, PropertySchema propertySchema) {
        this.getOrCreateLabel(nodeLabel).addProperty(propertyName, propertySchema);
        return this;
    }

    public MutableNodeSchema addProperty(NodeLabel nodeLabel, String propertyKey, ValueType valueType) {
        this.getOrCreateLabel(nodeLabel).addProperty(propertyKey, valueType);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MutableNodeSchema that = (MutableNodeSchema)o;
        return this.entries.equals(that.entries);
    }

    public int hashCode() {
        return this.entries.hashCode();
    }
}

