/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.api.schema;

import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.neo4j.gds.api.DefaultValue;
import org.neo4j.gds.api.PropertyState;
import org.neo4j.gds.api.nodeproperties.ValueType;
import org.neo4j.gds.api.schema.PropertySchema;
import org.neo4j.gds.api.schema.RelationshipPropertySchema;
import org.neo4j.gds.core.Aggregation;

@Generated(from="RelationshipPropertySchema", generator="Immutables")
public final class ImmutableRelationshipPropertySchema
implements RelationshipPropertySchema {
    private final String key;
    private final ValueType valueType;
    private final DefaultValue defaultValue;
    private final PropertyState state;
    private final Aggregation aggregation;

    private ImmutableRelationshipPropertySchema(String key, ValueType valueType, DefaultValue defaultValue, PropertyState state, Aggregation aggregation) {
        this.key = Objects.requireNonNull(key, "key");
        this.valueType = Objects.requireNonNull(valueType, "valueType");
        this.defaultValue = Objects.requireNonNull(defaultValue, "defaultValue");
        this.state = Objects.requireNonNull(state, "state");
        this.aggregation = Objects.requireNonNull(aggregation, "aggregation");
    }

    private ImmutableRelationshipPropertySchema(ImmutableRelationshipPropertySchema original, String key, ValueType valueType, DefaultValue defaultValue, PropertyState state, Aggregation aggregation) {
        this.key = key;
        this.valueType = valueType;
        this.defaultValue = defaultValue;
        this.state = state;
        this.aggregation = aggregation;
    }

    @Override
    public String key() {
        return this.key;
    }

    @Override
    public ValueType valueType() {
        return this.valueType;
    }

    @Override
    public DefaultValue defaultValue() {
        return this.defaultValue;
    }

    @Override
    public PropertyState state() {
        return this.state;
    }

    @Override
    public Aggregation aggregation() {
        return this.aggregation;
    }

    public final ImmutableRelationshipPropertySchema withKey(String value) {
        String newValue = Objects.requireNonNull(value, "key");
        if (this.key.equals(newValue)) {
            return this;
        }
        return ImmutableRelationshipPropertySchema.validate(new ImmutableRelationshipPropertySchema(this, newValue, this.valueType, this.defaultValue, this.state, this.aggregation));
    }

    public final ImmutableRelationshipPropertySchema withValueType(ValueType value) {
        if (this.valueType == value) {
            return this;
        }
        ValueType newValue = Objects.requireNonNull(value, "valueType");
        if (this.valueType.equals((Object)newValue)) {
            return this;
        }
        return ImmutableRelationshipPropertySchema.validate(new ImmutableRelationshipPropertySchema(this, this.key, newValue, this.defaultValue, this.state, this.aggregation));
    }

    public final ImmutableRelationshipPropertySchema withDefaultValue(DefaultValue value) {
        if (this.defaultValue == value) {
            return this;
        }
        DefaultValue newValue = Objects.requireNonNull(value, "defaultValue");
        return ImmutableRelationshipPropertySchema.validate(new ImmutableRelationshipPropertySchema(this, this.key, this.valueType, newValue, this.state, this.aggregation));
    }

    public final ImmutableRelationshipPropertySchema withState(PropertyState value) {
        if (this.state == value) {
            return this;
        }
        PropertyState newValue = Objects.requireNonNull(value, "state");
        if (this.state.equals((Object)newValue)) {
            return this;
        }
        return ImmutableRelationshipPropertySchema.validate(new ImmutableRelationshipPropertySchema(this, this.key, this.valueType, this.defaultValue, newValue, this.aggregation));
    }

    public final ImmutableRelationshipPropertySchema withAggregation(Aggregation value) {
        if (this.aggregation == value) {
            return this;
        }
        Aggregation newValue = Objects.requireNonNull(value, "aggregation");
        if (this.aggregation.equals((Object)newValue)) {
            return this;
        }
        return ImmutableRelationshipPropertySchema.validate(new ImmutableRelationshipPropertySchema(this, this.key, this.valueType, this.defaultValue, this.state, newValue));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRelationshipPropertySchema && this.equalTo((ImmutableRelationshipPropertySchema)another);
    }

    private boolean equalTo(ImmutableRelationshipPropertySchema another) {
        return this.key.equals(another.key) && this.valueType.equals((Object)another.valueType) && this.defaultValue.equals((Object)another.defaultValue) && this.aggregation.equals((Object)another.aggregation);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.key.hashCode();
        h += (h << 5) + this.valueType.hashCode();
        h += (h << 5) + this.defaultValue.hashCode();
        h += (h << 5) + this.aggregation.hashCode();
        return h;
    }

    public String toString() {
        return "RelationshipPropertySchema{key=" + this.key + ", valueType=" + this.valueType + ", defaultValue=" + this.defaultValue + ", aggregation=" + this.aggregation + "}";
    }

    public static RelationshipPropertySchema of(String key, ValueType valueType, DefaultValue defaultValue, PropertyState state, Aggregation aggregation) {
        return ImmutableRelationshipPropertySchema.validate(new ImmutableRelationshipPropertySchema(key, valueType, defaultValue, state, aggregation));
    }

    private static ImmutableRelationshipPropertySchema validate(ImmutableRelationshipPropertySchema instance) {
        instance = (ImmutableRelationshipPropertySchema)instance.normalize();
        return instance;
    }

    public static RelationshipPropertySchema copyOf(RelationshipPropertySchema instance) {
        if (instance instanceof ImmutableRelationshipPropertySchema) {
            return (ImmutableRelationshipPropertySchema)instance;
        }
        return ImmutableRelationshipPropertySchema.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="RelationshipPropertySchema", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_KEY = 1L;
        private static final long INIT_BIT_VALUE_TYPE = 2L;
        private static final long INIT_BIT_DEFAULT_VALUE = 4L;
        private static final long INIT_BIT_STATE = 8L;
        private static final long INIT_BIT_AGGREGATION = 16L;
        private long initBits = 31L;
        private String key;
        private ValueType valueType;
        private DefaultValue defaultValue;
        private PropertyState state;
        private Aggregation aggregation;

        private Builder() {
        }

        public final Builder from(PropertySchema instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(RelationshipPropertySchema instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PropertySchema instance;
            if (object instanceof PropertySchema) {
                instance = (PropertySchema)object;
                this.state(instance.state());
                this.defaultValue(instance.defaultValue());
                this.key(instance.key());
                this.valueType(instance.valueType());
            }
            if (object instanceof RelationshipPropertySchema) {
                instance = (RelationshipPropertySchema)object;
                this.aggregation(instance.aggregation());
            }
        }

        public final Builder key(String key) {
            this.key = Objects.requireNonNull(key, "key");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder valueType(ValueType valueType) {
            this.valueType = Objects.requireNonNull(valueType, "valueType");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder defaultValue(DefaultValue defaultValue) {
            this.defaultValue = Objects.requireNonNull(defaultValue, "defaultValue");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder state(PropertyState state) {
            this.state = Objects.requireNonNull(state, "state");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder aggregation(Aggregation aggregation) {
            this.aggregation = Objects.requireNonNull(aggregation, "aggregation");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public Builder clear() {
            this.initBits = 31L;
            this.key = null;
            this.valueType = null;
            this.defaultValue = null;
            this.state = null;
            this.aggregation = null;
            return this;
        }

        public RelationshipPropertySchema build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableRelationshipPropertySchema.validate(new ImmutableRelationshipPropertySchema(null, this.key, this.valueType, this.defaultValue, this.state, this.aggregation));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("key");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("valueType");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("defaultValue");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("state");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("aggregation");
            }
            return "Cannot build RelationshipPropertySchema, some of required attributes are not set " + attributes;
        }
    }
}

