/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.api.schema;

import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.schema.Direction;
import org.neo4j.gds.api.schema.MutableGraphSchema;
import org.neo4j.gds.api.schema.NodeSchema;
import org.neo4j.gds.api.schema.PropertySchema;
import org.neo4j.gds.api.schema.RelationshipPropertySchema;
import org.neo4j.gds.api.schema.RelationshipSchema;

public interface GraphSchema {
    public NodeSchema nodeSchema();

    public RelationshipSchema relationshipSchema();

    public Map<String, PropertySchema> graphProperties();

    public GraphSchema filterNodeLabels(Set<NodeLabel> var1);

    public GraphSchema filterRelationshipTypes(Set<RelationshipType> var1);

    public GraphSchema union(GraphSchema var1);

    default public Map<String, Object> toMap() {
        return Map.of("nodes", this.nodeSchema().toMap(), "relationships", this.relationshipSchema().toMap(), "graphProperties", this.graphProperties().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, schema -> GraphSchema.forPropertySchema((PropertySchema)schema.getValue()))));
    }

    default public Map<String, Object> toMapOld() {
        return Map.of("nodes", this.nodeSchema().toMap(), "relationships", this.relationshipSchema().toMapOld(), "graphProperties", this.graphProperties().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, schema -> GraphSchema.forPropertySchema((PropertySchema)schema.getValue()))));
    }

    default public boolean isUndirected() {
        return this.relationshipSchema().isUndirected();
    }

    default public Direction direction() {
        return this.relationshipSchema().isUndirected() ? Direction.UNDIRECTED : Direction.DIRECTED;
    }

    public static GraphSchema empty() {
        return MutableGraphSchema.empty();
    }

    public static MutableGraphSchema mutable() {
        return MutableGraphSchema.empty();
    }

    public static <PS extends PropertySchema> String forPropertySchema(PS propertySchema) {
        if (propertySchema instanceof RelationshipPropertySchema) {
            return String.format(Locale.ENGLISH, "%s (%s, %s, Aggregation.%s)", new Object[]{propertySchema.valueType().cypherName(), propertySchema.defaultValue(), propertySchema.state(), ((RelationshipPropertySchema)propertySchema).aggregation()});
        }
        return String.format(Locale.ENGLISH, "%s (%s, %s)", new Object[]{propertySchema.valueType().cypherName(), propertySchema.defaultValue(), propertySchema.state()});
    }
}

