/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.api.schema;

import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.gds.ElementIdentifier;
import org.neo4j.gds.api.schema.PropertySchema;

public interface ElementSchemaEntry<SELF extends ElementSchemaEntry<SELF, ELEMENT_IDENTIFIER, PROPERTY_SCHEMA>, ELEMENT_IDENTIFIER extends ElementIdentifier, PROPERTY_SCHEMA extends PropertySchema> {
    public ELEMENT_IDENTIFIER identifier();

    public Map<String, PROPERTY_SCHEMA> properties();

    public SELF union(SELF var1);

    public Map<String, Object> toMap();

    default public Map<String, PROPERTY_SCHEMA> unionProperties(Map<String, PROPERTY_SCHEMA> rightProperties) {
        return Stream.concat(this.properties().entrySet().stream(), rightProperties.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (leftType, rightType) -> {
            if (leftType.valueType() != rightType.valueType()) {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Combining schema entries with value type %s and %s is not supported.", this.properties().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((PropertySchema)entry.getValue()).valueType())), rightProperties.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((PropertySchema)entry.getValue()).valueType()))));
            }
            return leftType;
        }));
    }
}

