/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.executor;

import org.neo4j.gds.Algorithm;
import org.neo4j.gds.AlgorithmFactory;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.core.GraphDimensions;
import org.neo4j.gds.core.utils.mem.MemoryEstimations;
import org.neo4j.gds.core.utils.mem.MemoryTree;
import org.neo4j.gds.core.utils.mem.MemoryTreeWithDimensions;

public class ProcedureMemoryEstimation<ALGO extends Algorithm<?>, CONFIG extends AlgoBaseConfig> {
    private final AlgorithmFactory<?, ALGO, CONFIG> algorithmFactory;
    private final GraphDimensions graphDimensions;

    public ProcedureMemoryEstimation(GraphDimensions graphDimensions, AlgorithmFactory<?, ALGO, CONFIG> algorithmFactory) {
        this.graphDimensions = graphDimensions;
        this.algorithmFactory = algorithmFactory;
    }

    public MemoryTreeWithDimensions memoryEstimation(CONFIG config) {
        MemoryEstimations.Builder estimationBuilder = MemoryEstimations.builder((String)"Memory Estimation");
        estimationBuilder.add("algorithm", this.algorithmFactory.memoryEstimation(config));
        GraphDimensions extendedDimension = this.algorithmFactory.estimatedGraphDimensionTransformer(this.graphDimensions, config);
        MemoryTree memoryTree = estimationBuilder.build().estimate(extendedDimension, config.concurrency());
        return new MemoryTreeWithDimensions(memoryTree, this.graphDimensions);
    }
}

