/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.executor;

import java.util.function.BiFunction;
import org.neo4j.gds.Algorithm;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.executor.GraphCreation;
import org.neo4j.gds.executor.GraphCreationFactory;
import org.neo4j.gds.executor.GraphStoreLoader;
import org.neo4j.gds.executor.MemoryUsageValidator;
import org.neo4j.gds.executor.ProcedureGraphCreation;

public class ProcedureGraphCreationFactory<ALGO extends Algorithm<ALGO_RESULT>, ALGO_RESULT, CONFIG extends AlgoBaseConfig>
implements GraphCreationFactory<ALGO, ALGO_RESULT, CONFIG> {
    private final BiFunction<CONFIG, String, GraphStoreLoader> graphStoreLoaderFn;
    private final MemoryUsageValidator memoryUsageValidator;

    public ProcedureGraphCreationFactory(BiFunction<CONFIG, String, GraphStoreLoader> graphStoreLoaderFn, MemoryUsageValidator memoryUsageValidator) {
        this.graphStoreLoaderFn = graphStoreLoaderFn;
        this.memoryUsageValidator = memoryUsageValidator;
    }

    @Override
    public GraphCreation<ALGO, ALGO_RESULT, CONFIG> create(CONFIG config, String graphName) {
        return new ProcedureGraphCreation(this.graphStoreLoaderFn.apply(config, graphName), this.memoryUsageValidator, config);
    }
}

