/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.executor;

import java.util.Map;
import java.util.function.Supplier;
import org.neo4j.gds.Algorithm;
import org.neo4j.gds.AlgorithmFactory;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.GraphStoreAlgorithmFactory;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.GraphProjectConfig;
import org.neo4j.gds.core.utils.ProgressTimer;
import org.neo4j.gds.core.utils.TerminationFlag;
import org.neo4j.gds.core.utils.mem.MemoryRange;
import org.neo4j.gds.executor.AlgorithmMetaData;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.ExecutorSpec;
import org.neo4j.gds.executor.GraphCreation;
import org.neo4j.gds.executor.ImmutableComputationResult;
import org.neo4j.gds.executor.validation.Validator;
import org.neo4j.kernel.api.KernelTransaction;

public class ProcedureExecutor<ALGO extends Algorithm<ALGO_RESULT>, ALGO_RESULT, CONFIG extends AlgoBaseConfig, RESULT> {
    private final AlgorithmSpec<ALGO, ALGO_RESULT, CONFIG, RESULT, ?> algoSpec;
    private final ExecutorSpec<ALGO, ALGO_RESULT, CONFIG> executorSpec;
    private final ExecutionContext executionContext;

    public ProcedureExecutor(AlgorithmSpec<ALGO, ALGO_RESULT, CONFIG, RESULT, ?> algoSpec, ExecutorSpec<ALGO, ALGO_RESULT, CONFIG> executorSpec, ExecutionContext executionContext) {
        this.algoSpec = algoSpec;
        this.executorSpec = executorSpec;
        this.executionContext = executionContext;
    }

    public ProcedureExecutor(AlgorithmSpec<ALGO, ALGO_RESULT, CONFIG, RESULT, ?> algoSpec, ExecutionContext executionContext) {
        this(algoSpec, algoSpec.createDefaultExecutorSpec(), executionContext);
    }

    public RESULT compute(String graphName, Map<String, Object> configuration, boolean releaseAlgorithm, boolean releaseTopology) {
        Graph graph;
        GraphStore graphStore;
        ImmutableComputationResult.Builder builder = ImmutableComputationResult.builder();
        AlgoBaseConfig config = (AlgoBaseConfig)this.executorSpec.configParser(this.algoSpec.newConfigFunction(), this.executionContext).processInput(configuration);
        this.setAlgorithmMetaDataToTransaction(config);
        GraphCreation<ALGO, ALGO_RESULT, AlgoBaseConfig> graphCreation = this.executorSpec.graphCreationFactory(this.executionContext).create(config, graphName);
        MemoryRange memoryEstimationInBytes = graphCreation.validateMemoryEstimation((AlgorithmFactory<?, ALGO, AlgoBaseConfig>)this.algoSpec.algorithmFactory());
        try (ProgressTimer timer = ProgressTimer.start(builder::preProcessingMillis);){
            GraphProjectConfig graphProjectConfig = graphCreation.graphProjectConfig();
            Validator<AlgoBaseConfig> validator = this.executorSpec.validator(this.algoSpec.validationConfig());
            validator.validateConfigsBeforeLoad(graphProjectConfig, config);
            graphStore = graphCreation.graphStore();
            validator.validateConfigWithGraphStore(graphStore, graphProjectConfig, config);
            graph = graphCreation.createGraph(graphStore);
        }
        if (graph.isEmpty()) {
            ComputationResult<Object, Object, AlgoBaseConfig> emptyComputationResult = builder.isGraphEmpty(true).graph(graph).graphStore(graphStore).config(config).computeMillis(0L).result(null).algorithm(null).build();
            return this.algoSpec.computationResultConsumer().consume(emptyComputationResult, this.executionContext);
        }
        ALGO algo = this.newAlgorithm(graph, graphStore, config);
        algo.getProgressTracker().setEstimatedResourceFootprint(memoryEstimationInBytes, config.concurrency());
        Object result = this.executeAlgorithm(releaseAlgorithm, releaseTopology, builder, graph, algo);
        ComputationResult computationResult = builder.graph(graph).graphStore(graphStore).algorithm(algo).result(result).config(config).build();
        return this.algoSpec.computationResultConsumer().consume(computationResult, this.executionContext);
    }

    private ALGO_RESULT executeAlgorithm(boolean releaseAlgorithm, boolean releaseTopology, ImmutableComputationResult.Builder<ALGO, ALGO_RESULT, CONFIG> builder, Graph graph, ALGO algo) {
        return (ALGO_RESULT)this.runWithExceptionLogging("Computation failed", () -> {
            try {
                Object object;
                block13: {
                    ProgressTimer ignored = ProgressTimer.start(builder::computeMillis);
                    try {
                        object = algo.compute();
                        if (ignored == null) break block13;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (ignored != null) {
                                try {
                                    ignored.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Throwable e) {
                            algo.getProgressTracker().endSubTaskWithFailure();
                            throw e;
                        }
                    }
                    ignored.close();
                }
                return object;
            }
            finally {
                if (releaseAlgorithm) {
                    algo.getProgressTracker().release();
                    algo.release();
                }
                if (releaseTopology) {
                    graph.releaseTopology();
                }
            }
        });
    }

    private ALGO newAlgorithm(final Graph graph, GraphStore graphStore, CONFIG config) {
        TerminationFlag terminationFlag = TerminationFlag.wrap((KernelTransaction)this.executionContext.transaction());
        Algorithm algorithm = this.algoSpec.algorithmFactory().accept(new AlgorithmFactory.Visitor<ALGO, CONFIG>((AlgoBaseConfig)config, graphStore){
            final /* synthetic */ AlgoBaseConfig val$config;
            final /* synthetic */ GraphStore val$graphStore;
            {
                this.val$config = algoBaseConfig;
                this.val$graphStore = graphStore;
            }

            public ALGO graph(GraphAlgorithmFactory<ALGO, CONFIG> graphAlgorithmFactory) {
                return graphAlgorithmFactory.build((Object)graph, this.val$config, ProcedureExecutor.this.executionContext.log(), ProcedureExecutor.this.executionContext.taskRegistryFactory(), ProcedureExecutor.this.executionContext.userLogRegistryFactory());
            }

            public ALGO graphStore(GraphStoreAlgorithmFactory<ALGO, CONFIG> graphStoreAlgorithmFactory) {
                return graphStoreAlgorithmFactory.build((Object)this.val$graphStore, this.val$config, ProcedureExecutor.this.executionContext.log(), ProcedureExecutor.this.executionContext.taskRegistryFactory(), ProcedureExecutor.this.executionContext.userLogRegistryFactory());
            }
        });
        algorithm.setTerminationFlag(terminationFlag);
        return (ALGO)algorithm;
    }

    private void setAlgorithmMetaDataToTransaction(CONFIG algoConfig) {
        if (this.executionContext.transaction() == null) {
            return;
        }
        Map metaData = this.executionContext.transaction().getMetaData();
        if (metaData instanceof AlgorithmMetaData) {
            ((AlgorithmMetaData)metaData).set((BaseConfig)algoConfig);
        }
    }

    private <R> R runWithExceptionLogging(String message, Supplier<R> supplier) {
        try {
            return supplier.get();
        }
        catch (Exception e) {
            this.executionContext.log().warn(message, (Throwable)e);
            throw e;
        }
    }
}

