/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.executor;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.gds.Algorithm;
import org.neo4j.gds.AlgorithmFactory;
import org.neo4j.gds.api.GraphLoaderContext;
import org.neo4j.gds.api.ImmutableGraphLoaderContext;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.GraphProjectConfig;
import org.neo4j.gds.core.GraphDimensions;
import org.neo4j.gds.core.utils.TerminationFlag;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.mem.MemoryEstimations;
import org.neo4j.gds.core.utils.mem.MemoryTree;
import org.neo4j.gds.core.utils.mem.MemoryTreeWithDimensions;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.ExecutorSpec;
import org.neo4j.gds.executor.FictitiousGraphStoreLoader;
import org.neo4j.gds.executor.GraphStoreCreator;
import org.neo4j.gds.executor.GraphStoreFromCatalogLoader;
import org.neo4j.gds.executor.GraphStoreFromDatabaseLoader;
import org.neo4j.gds.executor.MemoryEstimationGraphConfigParser;
import org.neo4j.gds.executor.ProcConfigParser;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.gds.transaction.TransactionContext;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

public class MemoryEstimationExecutor<ALGO extends Algorithm<ALGO_RESULT>, ALGO_RESULT, CONFIG extends AlgoBaseConfig> {
    private final AlgorithmSpec<ALGO, ALGO_RESULT, CONFIG, ?, ?> algoSpec;
    private final ExecutorSpec<ALGO, ALGO_RESULT, CONFIG> executorSpec;
    private final ExecutionContext executionContext;

    public MemoryEstimationExecutor(AlgorithmSpec<ALGO, ALGO_RESULT, CONFIG, ?, ?> algoSpec, ExecutorSpec<ALGO, ALGO_RESULT, CONFIG> executorSpec, ExecutionContext executionContext) {
        this.algoSpec = algoSpec;
        this.executorSpec = executorSpec;
        this.executionContext = executionContext;
    }

    public MemoryEstimationExecutor(AlgorithmSpec<ALGO, ALGO_RESULT, CONFIG, ?, ?> algoSpec, ExecutionContext executionContext) {
        this(algoSpec, algoSpec.createDefaultExecutorSpec(), executionContext);
    }

    public Stream<MemoryEstimateResult> computeEstimate(Object graphNameOrConfiguration, Map<String, Object> algoConfiguration) {
        Optional<MemoryEstimation> maybeGraphEstimation;
        GraphDimensions graphDims;
        ProcConfigParser<CONFIG> configParser = this.executorSpec.configParser(this.algoSpec.newConfigFunction(), this.executionContext);
        AlgoBaseConfig algoConfig = (AlgoBaseConfig)configParser.processInput(algoConfiguration);
        if (graphNameOrConfiguration instanceof Map) {
            GraphLoaderContext graphLoaderContext = this.executionContext.api() == null ? GraphLoaderContext.NULL_CONTEXT : ImmutableGraphLoaderContext.builder().api(this.executionContext.api()).log(this.executionContext.log()).taskRegistryFactory(this.executionContext.taskRegistryFactory()).userLogRegistryFactory(this.executionContext.userLogRegistryFactory()).terminationFlag(TerminationFlag.wrap((KernelTransaction)this.executionContext.transaction())).transactionContext(TransactionContext.of((GraphDatabaseAPI)this.executionContext.api(), (Transaction)this.executionContext.procedureTransaction())).build();
            MemoryEstimationGraphConfigParser memoryEstimationGraphConfigParser = new MemoryEstimationGraphConfigParser(this.executionContext.username());
            GraphProjectConfig graphProjectConfig = memoryEstimationGraphConfigParser.processInput(graphNameOrConfiguration);
            GraphStoreCreator graphStoreCreator = graphProjectConfig.isFictitiousLoading() ? new FictitiousGraphStoreLoader(graphProjectConfig) : new GraphStoreFromDatabaseLoader(graphProjectConfig, this.executionContext.username(), graphLoaderContext);
            graphDims = graphStoreCreator.graphDimensions();
            maybeGraphEstimation = Optional.of(graphStoreCreator.estimateMemoryUsageAfterLoading());
        } else if (graphNameOrConfiguration instanceof String) {
            graphDims = new GraphStoreFromCatalogLoader((String)graphNameOrConfiguration, algoConfig, this.executionContext.username(), this.executionContext.databaseId(), this.executionContext.isGdsAdmin()).graphDimensions();
            maybeGraphEstimation = Optional.empty();
        } else {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Expected `graphNameOrConfiguration` to be of type String or Map, but got", (Object[])new Object[]{graphNameOrConfiguration.getClass().getSimpleName()}));
        }
        MemoryTreeWithDimensions memoryTreeWithDimensions = this.procedureMemoryEstimation(graphDims, maybeGraphEstimation, (AlgorithmFactory<?, ALGO, CONFIG>)this.algoSpec.algorithmFactory(), (CONFIG)algoConfig);
        return Stream.of(new MemoryEstimateResult(memoryTreeWithDimensions));
    }

    protected MemoryTreeWithDimensions procedureMemoryEstimation(GraphDimensions dimensions, Optional<MemoryEstimation> maybeEstimation, AlgorithmFactory<?, ALGO, CONFIG> algorithmFactory, CONFIG config) {
        MemoryEstimations.Builder estimationBuilder = MemoryEstimations.builder((String)"Memory Estimation");
        GraphDimensions extendedDimension = algorithmFactory.estimatedGraphDimensionTransformer(dimensions, config);
        maybeEstimation.ifPresent(graphMemoryEstimation -> estimationBuilder.add("graph", graphMemoryEstimation));
        estimationBuilder.add("algorithm", algorithmFactory.memoryEstimation(config));
        MemoryTree memoryTree = estimationBuilder.build().estimate(extendedDimension, config.concurrency());
        return new MemoryTreeWithDimensions(memoryTree, dimensions);
    }
}

