/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.executor;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.Algorithm;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.executor.ComputationResult;

@ParametersAreNonnullByDefault
@Generated(from="ComputationResult", generator="Immutables")
@Immutable
public final class ImmutableComputationResult<A extends Algorithm<ALGO_RESULT>, ALGO_RESULT, CONFIG extends AlgoBaseConfig>
implements ComputationResult<A, ALGO_RESULT, CONFIG> {
    private final long preProcessingMillis;
    private final long computeMillis;
    @Nullable
    private final A algorithm;
    @Nullable
    private final ALGO_RESULT result;
    private final Graph graph;
    private final GraphStore graphStore;
    private final CONFIG config;
    private final boolean isGraphEmpty;

    private ImmutableComputationResult(long preProcessingMillis, long computeMillis, @Nullable A algorithm, @Nullable ALGO_RESULT result, Graph graph, GraphStore graphStore, CONFIG config, boolean isGraphEmpty) {
        this.preProcessingMillis = preProcessingMillis;
        this.computeMillis = computeMillis;
        this.algorithm = algorithm;
        this.result = result;
        this.graph = Objects.requireNonNull(graph, "graph");
        this.graphStore = Objects.requireNonNull(graphStore, "graphStore");
        this.config = (AlgoBaseConfig)Objects.requireNonNull(config, "config");
        this.isGraphEmpty = isGraphEmpty;
    }

    private ImmutableComputationResult(Builder<A, ALGO_RESULT, CONFIG> builder) {
        this.preProcessingMillis = builder.preProcessingMillis;
        this.computeMillis = builder.computeMillis;
        this.algorithm = builder.algorithm;
        this.result = builder.result;
        this.graph = builder.graph;
        this.graphStore = builder.graphStore;
        this.config = builder.config;
        this.isGraphEmpty = builder.isGraphEmptyIsSet() ? builder.isGraphEmpty : ComputationResult.super.isGraphEmpty();
    }

    private ImmutableComputationResult(ImmutableComputationResult<A, ALGO_RESULT, CONFIG> original, long preProcessingMillis, long computeMillis, @Nullable A algorithm, @Nullable ALGO_RESULT result, Graph graph, GraphStore graphStore, CONFIG config, boolean isGraphEmpty) {
        this.preProcessingMillis = preProcessingMillis;
        this.computeMillis = computeMillis;
        this.algorithm = algorithm;
        this.result = result;
        this.graph = graph;
        this.graphStore = graphStore;
        this.config = config;
        this.isGraphEmpty = isGraphEmpty;
    }

    @Override
    public long preProcessingMillis() {
        return this.preProcessingMillis;
    }

    @Override
    public long computeMillis() {
        return this.computeMillis;
    }

    @Override
    @Nullable
    public A algorithm() {
        return this.algorithm;
    }

    @Override
    @Nullable
    public ALGO_RESULT result() {
        return this.result;
    }

    @Override
    public Graph graph() {
        return this.graph;
    }

    @Override
    public GraphStore graphStore() {
        return this.graphStore;
    }

    @Override
    public CONFIG config() {
        return this.config;
    }

    @Override
    public boolean isGraphEmpty() {
        return this.isGraphEmpty;
    }

    public final ImmutableComputationResult<A, ALGO_RESULT, CONFIG> withPreProcessingMillis(long value) {
        if (this.preProcessingMillis == value) {
            return this;
        }
        return new ImmutableComputationResult<A, ALGO_RESULT, CONFIG>(this, value, this.computeMillis, this.algorithm, this.result, this.graph, this.graphStore, this.config, this.isGraphEmpty);
    }

    public final ImmutableComputationResult<A, ALGO_RESULT, CONFIG> withComputeMillis(long value) {
        if (this.computeMillis == value) {
            return this;
        }
        return new ImmutableComputationResult<A, ALGO_RESULT, CONFIG>(this, this.preProcessingMillis, value, this.algorithm, this.result, this.graph, this.graphStore, this.config, this.isGraphEmpty);
    }

    public final ImmutableComputationResult<A, ALGO_RESULT, CONFIG> withAlgorithm(@Nullable A value) {
        if (this.algorithm == value) {
            return this;
        }
        return new ImmutableComputationResult<A, ALGO_RESULT, CONFIG>(this, this.preProcessingMillis, this.computeMillis, value, this.result, this.graph, this.graphStore, this.config, this.isGraphEmpty);
    }

    public final ImmutableComputationResult<A, ALGO_RESULT, CONFIG> withResult(@Nullable ALGO_RESULT value) {
        if (this.result == value) {
            return this;
        }
        return new ImmutableComputationResult<A, ALGO_RESULT, CONFIG>(this, this.preProcessingMillis, this.computeMillis, this.algorithm, value, this.graph, this.graphStore, this.config, this.isGraphEmpty);
    }

    public final ImmutableComputationResult<A, ALGO_RESULT, CONFIG> withGraph(Graph value) {
        if (this.graph == value) {
            return this;
        }
        Graph newValue = Objects.requireNonNull(value, "graph");
        return new ImmutableComputationResult<A, ALGO_RESULT, CONFIG>(this, this.preProcessingMillis, this.computeMillis, this.algorithm, this.result, newValue, this.graphStore, this.config, this.isGraphEmpty);
    }

    public final ImmutableComputationResult<A, ALGO_RESULT, CONFIG> withGraphStore(GraphStore value) {
        if (this.graphStore == value) {
            return this;
        }
        GraphStore newValue = Objects.requireNonNull(value, "graphStore");
        return new ImmutableComputationResult<A, ALGO_RESULT, CONFIG>(this, this.preProcessingMillis, this.computeMillis, this.algorithm, this.result, this.graph, newValue, this.config, this.isGraphEmpty);
    }

    public final ImmutableComputationResult<A, ALGO_RESULT, CONFIG> withConfig(CONFIG value) {
        if (this.config == value) {
            return this;
        }
        AlgoBaseConfig newValue = (AlgoBaseConfig)Objects.requireNonNull(value, "config");
        return new ImmutableComputationResult<A, ALGO_RESULT, AlgoBaseConfig>(this, this.preProcessingMillis, this.computeMillis, this.algorithm, this.result, this.graph, this.graphStore, newValue, this.isGraphEmpty);
    }

    public final ImmutableComputationResult<A, ALGO_RESULT, CONFIG> withIsGraphEmpty(boolean value) {
        if (this.isGraphEmpty == value) {
            return this;
        }
        return new ImmutableComputationResult<A, ALGO_RESULT, CONFIG>(this, this.preProcessingMillis, this.computeMillis, this.algorithm, this.result, this.graph, this.graphStore, this.config, value);
    }

    public boolean equals(@javax.annotation.Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableComputationResult && this.equalTo((ImmutableComputationResult)another);
    }

    private boolean equalTo(ImmutableComputationResult<?, ?, ?> another) {
        return this.preProcessingMillis == another.preProcessingMillis && this.computeMillis == another.computeMillis && Objects.equals(this.algorithm, another.algorithm) && Objects.equals(this.result, another.result) && this.graph.equals(another.graph) && this.graphStore.equals(another.graphStore) && this.config.equals(another.config) && this.isGraphEmpty == another.isGraphEmpty;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Long.hashCode(this.preProcessingMillis);
        h += (h << 5) + Long.hashCode(this.computeMillis);
        h += (h << 5) + Objects.hashCode(this.algorithm);
        h += (h << 5) + Objects.hashCode(this.result);
        h += (h << 5) + this.graph.hashCode();
        h += (h << 5) + this.graphStore.hashCode();
        h += (h << 5) + this.config.hashCode();
        h += (h << 5) + Boolean.hashCode(this.isGraphEmpty);
        return h;
    }

    public String toString() {
        return "ComputationResult{preProcessingMillis=" + this.preProcessingMillis + ", computeMillis=" + this.computeMillis + ", algorithm=" + this.algorithm + ", result=" + this.result + ", graph=" + this.graph + ", graphStore=" + this.graphStore + ", config=" + this.config + ", isGraphEmpty=" + this.isGraphEmpty + "}";
    }

    public static <A extends Algorithm<ALGO_RESULT>, ALGO_RESULT, CONFIG extends AlgoBaseConfig> ComputationResult<A, ALGO_RESULT, CONFIG> of(long preProcessingMillis, long computeMillis, @Nullable A algorithm, @Nullable ALGO_RESULT result, Graph graph, GraphStore graphStore, CONFIG config, boolean isGraphEmpty) {
        return new ImmutableComputationResult<A, ALGO_RESULT, CONFIG>(preProcessingMillis, computeMillis, algorithm, result, graph, graphStore, config, isGraphEmpty);
    }

    public static <A extends Algorithm<ALGO_RESULT>, ALGO_RESULT, CONFIG extends AlgoBaseConfig> ComputationResult<A, ALGO_RESULT, CONFIG> copyOf(ComputationResult<A, ALGO_RESULT, CONFIG> instance) {
        if (instance instanceof ImmutableComputationResult) {
            return (ImmutableComputationResult)instance;
        }
        return ImmutableComputationResult.builder().from(instance).build();
    }

    public static <A extends Algorithm<ALGO_RESULT>, ALGO_RESULT, CONFIG extends AlgoBaseConfig> Builder<A, ALGO_RESULT, CONFIG> builder() {
        return new Builder();
    }

    @Generated(from="ComputationResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder<A extends Algorithm<ALGO_RESULT>, ALGO_RESULT, CONFIG extends AlgoBaseConfig> {
        private static final long INIT_BIT_PRE_PROCESSING_MILLIS = 1L;
        private static final long INIT_BIT_COMPUTE_MILLIS = 2L;
        private static final long INIT_BIT_GRAPH = 4L;
        private static final long INIT_BIT_GRAPH_STORE = 8L;
        private static final long INIT_BIT_CONFIG = 16L;
        private static final long OPT_BIT_IS_GRAPH_EMPTY = 1L;
        private long initBits = 31L;
        private long optBits;
        private long preProcessingMillis;
        private long computeMillis;
        @javax.annotation.Nullable
        private A algorithm;
        @javax.annotation.Nullable
        private ALGO_RESULT result;
        @javax.annotation.Nullable
        private Graph graph;
        @javax.annotation.Nullable
        private GraphStore graphStore;
        @javax.annotation.Nullable
        private CONFIG config;
        private boolean isGraphEmpty;

        private Builder() {
        }

        public final Builder<A, ALGO_RESULT, CONFIG> from(ComputationResult<A, ALGO_RESULT, CONFIG> instance) {
            ALGO_RESULT resultValue;
            Objects.requireNonNull(instance, "instance");
            this.preProcessingMillis(instance.preProcessingMillis());
            this.computeMillis(instance.computeMillis());
            @Nullable A algorithmValue = instance.algorithm();
            if (algorithmValue != null) {
                this.algorithm(algorithmValue);
            }
            if ((resultValue = instance.result()) != null) {
                this.result(resultValue);
            }
            this.graph(instance.graph());
            this.graphStore(instance.graphStore());
            this.config(instance.config());
            this.isGraphEmpty(instance.isGraphEmpty());
            return this;
        }

        public final Builder<A, ALGO_RESULT, CONFIG> preProcessingMillis(long preProcessingMillis) {
            this.preProcessingMillis = preProcessingMillis;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder<A, ALGO_RESULT, CONFIG> computeMillis(long computeMillis) {
            this.computeMillis = computeMillis;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder<A, ALGO_RESULT, CONFIG> algorithm(@Nullable A algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public final Builder<A, ALGO_RESULT, CONFIG> result(@Nullable ALGO_RESULT result) {
            this.result = result;
            return this;
        }

        public final Builder<A, ALGO_RESULT, CONFIG> graph(Graph graph) {
            this.graph = Objects.requireNonNull(graph, "graph");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder<A, ALGO_RESULT, CONFIG> graphStore(GraphStore graphStore) {
            this.graphStore = Objects.requireNonNull(graphStore, "graphStore");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder<A, ALGO_RESULT, CONFIG> config(CONFIG config) {
            this.config = (AlgoBaseConfig)Objects.requireNonNull(config, "config");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder<A, ALGO_RESULT, CONFIG> isGraphEmpty(boolean isGraphEmpty) {
            this.isGraphEmpty = isGraphEmpty;
            this.optBits |= 1L;
            return this;
        }

        public Builder<A, ALGO_RESULT, CONFIG> clear() {
            this.initBits = 31L;
            this.optBits = 0L;
            this.preProcessingMillis = 0L;
            this.computeMillis = 0L;
            this.algorithm = null;
            this.result = null;
            this.graph = null;
            this.graphStore = null;
            this.config = null;
            this.isGraphEmpty = false;
            return this;
        }

        public ComputationResult<A, ALGO_RESULT, CONFIG> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableComputationResult(this);
        }

        private boolean isGraphEmptyIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("preProcessingMillis");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("computeMillis");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("graph");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("graphStore");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("config");
            }
            return "Cannot build ComputationResult, some of required attributes are not set " + attributes;
        }
    }
}

