/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.executor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.neo4j.gds.ElementIdentifier;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.ConfigurableSeedConfig;
import org.neo4j.gds.config.FeaturePropertiesConfig;
import org.neo4j.gds.config.MutatePropertyConfig;
import org.neo4j.gds.config.MutateRelationshipConfig;
import org.neo4j.gds.config.SeedConfig;
import org.neo4j.gds.config.SourceNodeConfig;
import org.neo4j.gds.config.SourceNodesConfig;
import org.neo4j.gds.config.TargetNodeConfig;
import org.neo4j.gds.config.TargetNodePropertyConfig;
import org.neo4j.gds.config.TargetNodesConfig;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.gds.utils.StringJoining;

public final class GraphStoreValidation {
    public static void validate(GraphStore graphStore, AlgoBaseConfig config) {
        Collection filterLabels = config.nodeLabelIdentifiers(graphStore);
        if (config instanceof SeedConfig) {
            GraphStoreValidation.validateSeedProperty(graphStore, (SeedConfig)config, filterLabels);
        }
        if (config instanceof ConfigurableSeedConfig) {
            GraphStoreValidation.validateConfigurableSeedProperty(graphStore, (ConfigurableSeedConfig)config, filterLabels);
        }
        if (config instanceof FeaturePropertiesConfig) {
            GraphStoreValidation.validateFeaturesProperties(graphStore, (FeaturePropertiesConfig)config, filterLabels);
        }
        if (config instanceof MutatePropertyConfig) {
            GraphStoreValidation.validateMutateProperty(graphStore, filterLabels, (MutatePropertyConfig)config);
        }
        if (config instanceof MutateRelationshipConfig) {
            GraphStoreValidation.validateMutateRelationships(graphStore, (MutateRelationshipConfig)config);
        }
        if (config instanceof SourceNodesConfig) {
            GraphStoreValidation.validateSourceNodes(graphStore, (SourceNodesConfig)config, filterLabels);
        }
        if (config instanceof SourceNodeConfig) {
            GraphStoreValidation.validateSourceNode(graphStore, (SourceNodeConfig)config, filterLabels);
        }
        if (config instanceof TargetNodeConfig) {
            GraphStoreValidation.validateTargetNode(graphStore, (TargetNodeConfig)config, filterLabels);
        }
        if (config instanceof TargetNodesConfig) {
            GraphStoreValidation.validateTargetNodes(graphStore, (TargetNodesConfig)config, filterLabels);
        }
        if (config instanceof TargetNodePropertyConfig) {
            GraphStoreValidation.validateTargetNodeProperty(graphStore, (TargetNodePropertyConfig)config, filterLabels);
        }
    }

    private static void validateSeedProperty(GraphStore graphStore, SeedConfig config, Collection<NodeLabel> filterLabels) {
        String seedProperty = config.seedProperty();
        if (seedProperty != null && !graphStore.hasNodeProperty(filterLabels, seedProperty)) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Seed property `%s` not found in graph with node properties: %s", (Object[])new Object[]{seedProperty, graphStore.nodePropertyKeys().values().stream().flatMap(Collection::stream).sorted().collect(Collectors.toList())}));
        }
    }

    private static void validateConfigurableSeedProperty(GraphStore graphStore, ConfigurableSeedConfig config, Collection<NodeLabel> filterLabels) {
        String seedProperty = config.seedProperty();
        if (seedProperty != null && !graphStore.hasNodeProperty(filterLabels, seedProperty)) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"`%s`: `%s` not found in graph with node properties: %s", (Object[])new Object[]{config.propertyNameOverride(), seedProperty, graphStore.nodePropertyKeys().values().stream().flatMap(Collection::stream).sorted().collect(Collectors.toList())}));
        }
    }

    private static void validateMutateProperty(GraphStore graphStore, Collection<NodeLabel> filterLabels, MutatePropertyConfig mutateConfig) {
        String mutateProperty = mutateConfig.mutateProperty();
        GraphStoreValidation.validateNodePropertyDoesNotExist(graphStore, filterLabels, mutateProperty);
    }

    private static void validateNodePropertyDoesNotExist(GraphStore graphStore, Collection<NodeLabel> filterLabels, String nodeProperty) {
        if (nodeProperty != null && graphStore.hasNodeProperty(filterLabels, nodeProperty)) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Node property `%s` already exists in the in-memory graph.", (Object[])new Object[]{nodeProperty}));
        }
    }

    private static void validateMutateRelationships(GraphStore graphStore, MutateRelationshipConfig config) {
        String mutateRelationshipType = config.mutateRelationshipType();
        if (mutateRelationshipType != null && graphStore.hasRelationshipType(RelationshipType.of((String)mutateRelationshipType))) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Relationship type `%s` already exists in the in-memory graph.", (Object[])new Object[]{mutateRelationshipType}));
        }
    }

    private static void validateFeaturesProperties(GraphStore graphStore, FeaturePropertiesConfig config, Collection<NodeLabel> filterLabels) {
        List missingProperties;
        List weightProperties = config.featureProperties();
        if (config.propertiesMustExistForEachNodeLabel()) {
            missingProperties = weightProperties.stream().filter(weightProperty -> !graphStore.hasNodeProperty(filterLabels, weightProperty)).collect(Collectors.toList());
        } else {
            Set availableProperties = filterLabels.stream().flatMap(label -> graphStore.nodePropertyKeys(label).stream()).collect(Collectors.toSet());
            missingProperties = new ArrayList(weightProperties);
            missingProperties.removeAll(availableProperties);
        }
        if (!missingProperties.isEmpty()) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"The feature properties %s are not present for all requested labels. Requested labels: %s. Properties available on all requested labels: %s", (Object[])new Object[]{StringJoining.join(missingProperties), StringJoining.join(filterLabels.stream().map(ElementIdentifier::name)), StringJoining.join((Collection)graphStore.nodePropertyKeys(filterLabels))}));
        }
    }

    private static void validateSourceNode(GraphStore graphStore, SourceNodeConfig config, Collection<NodeLabel> filterLabels) {
        long sourceNodeId = config.sourceNode();
        if (GraphStoreValidation.labelFilteredGraphContainsNode(filterLabels, graphStore.nodes(), sourceNodeId)) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Source node does not exist in the in-memory graph%s: `%d`", (Object[])new Object[]{GraphStoreValidation.nodeLabelFilterDescription(filterLabels, graphStore), sourceNodeId}));
        }
    }

    private static void validateSourceNodes(GraphStore graphStore, SourceNodesConfig config, Collection<NodeLabel> filteredNodeLabels) {
        GraphStoreValidation.validateNodes(graphStore, config.sourceNodes(), filteredNodeLabels, "Source");
    }

    private static void validateTargetNode(GraphStore graphStore, TargetNodeConfig config, Collection<NodeLabel> filterLabels) {
        long targetNodeId = config.targetNode();
        if (GraphStoreValidation.labelFilteredGraphContainsNode(filterLabels, graphStore.nodes(), targetNodeId)) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Target node does not exist in the in-memory graph%s: `%d`", (Object[])new Object[]{GraphStoreValidation.nodeLabelFilterDescription(filterLabels, graphStore), targetNodeId}));
        }
    }

    private static void validateTargetNodes(GraphStore graphStore, TargetNodesConfig config, Collection<NodeLabel> filteredNodeLabels) {
        GraphStoreValidation.validateNodes(graphStore, config.targetNodes(), filteredNodeLabels, "Target");
    }

    private static void validateNodes(GraphStore graphStore, Collection<Long> nodesToValidate, Collection<NodeLabel> filteredNodeLabels, String nodeDescription) {
        List missingNodes;
        if (!nodesToValidate.isEmpty() && !(missingNodes = nodesToValidate.stream().filter(targetNode -> GraphStoreValidation.labelFilteredGraphContainsNode(filteredNodeLabels, graphStore.nodes(), targetNode)).map(Object::toString).collect(Collectors.toList())).isEmpty()) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"%s nodes do not exist in the in-memory graph%s: %s", (Object[])new Object[]{nodeDescription, GraphStoreValidation.nodeLabelFilterDescription(filteredNodeLabels, graphStore), StringJoining.join(missingNodes)}));
        }
    }

    private static String nodeLabelFilterDescription(Collection<NodeLabel> filteredNodeLabels, GraphStore graphStore) {
        return filteredNodeLabels.containsAll(graphStore.nodeLabels()) ? "" : " for the labels " + StringJoining.join(filteredNodeLabels.stream().map(ElementIdentifier::name));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean labelFilteredGraphContainsNode(Collection<NodeLabel> filteredNodeLabels, IdMap idMap, long neoNodeId) {
        long internalNodeId = idMap.safeToMappedNodeId(neoNodeId);
        if (internalNodeId == -1L) return true;
        if (!idMap.nodeLabels(internalNodeId).stream().noneMatch(filteredNodeLabels::contains)) return false;
        return true;
    }

    private static void validateTargetNodeProperty(GraphStore graphStore, TargetNodePropertyConfig config, Collection<NodeLabel> filterLabels) {
        String targetProperty = config.targetProperty();
        if (targetProperty != null && !graphStore.hasNodeProperty(filterLabels, targetProperty)) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Target property `%s` not found in graph with node properties: %s", (Object[])new Object[]{targetProperty, graphStore.nodePropertyKeys().values()}));
        }
    }

    private GraphStoreValidation() {
    }
}

