/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.projection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.core.CypherMapAccess;
import org.neo4j.gds.projection.AsJavaObject;
import org.neo4j.gds.projection.PartialValueMapper;
import org.neo4j.values.AnyValue;
import org.neo4j.values.SequenceValue;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.FloatingPointValue;
import org.neo4j.values.storable.IntegralValue;
import org.neo4j.values.storable.TextArray;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;

public final class ValueMapWrapper
implements CypherMapAccess {
    private final Map<String, AnyValue> config;

    public static ValueMapWrapper create(@Nullable MapValue config) {
        if (config == null || config.isEmpty()) {
            return ValueMapWrapper.empty();
        }
        TreeMap<String, AnyValue> configMap = new TreeMap<String, AnyValue>(String.CASE_INSENSITIVE_ORDER);
        config.foreach((key, value) -> {
            if (value != null && value != Values.NO_VALUE) {
                configMap.put((String)key, (AnyValue)value);
            }
        });
        return new ValueMapWrapper(configMap);
    }

    public static ValueMapWrapper empty() {
        return new ValueMapWrapper(Map.of());
    }

    private ValueMapWrapper(Map<String, AnyValue> config) {
        this.config = config;
    }

    public boolean containsKey(String key) {
        return this.config.containsKey(key);
    }

    public Collection<String> keySet() {
        return Collections.unmodifiableSet(this.config.keySet());
    }

    public int getLongAsInt(String key) {
        AnyValue value = this.config.get(key);
        if (value instanceof IntegralValue) {
            return Math.toIntExact(((IntegralValue)value).longValue());
        }
        return ValueMapWrapper.typedValue(key, Integer.class, value);
    }

    @NotNull
    public <V> V typedValue(String key, Class<V> expectedType) {
        return ValueMapWrapper.typedValue(key, expectedType, this.config.get(key));
    }

    private static <V> V typedValue(String key, Class<V> expectedType, AnyValue value) {
        CastMapper<V> mapper = new CastMapper<V>(key, expectedType);
        return (V)value.map(mapper);
    }

    public Map<String, Object> toMap() {
        return new HashMap<String, AnyValue>(this.config);
    }

    private static final class CastMapper<T>
    implements PartialValueMapper<T> {
        private final String key;
        private final Class<T> expectedType;

        private CastMapper(String key, Class<T> expectedType) {
            this.key = key;
            this.expectedType = expectedType;
        }

        public T mapIntegral(IntegralValue value) {
            if (Integer.class.isAssignableFrom(this.expectedType)) {
                return this.expectedType.cast(Math.toIntExact(value.longValue()));
            }
            if (Long.class.isAssignableFrom(this.expectedType)) {
                return this.expectedType.cast(value.longValue());
            }
            if (Number.class.isAssignableFrom(this.expectedType)) {
                return this.expectedType.cast(value.doubleValue());
            }
            return (T)PartialValueMapper.super.mapIntegral(value);
        }

        public T mapFloatingPoint(FloatingPointValue value) {
            if (Number.class.isAssignableFrom(this.expectedType)) {
                return this.expectedType.cast(value.longValue());
            }
            return (T)PartialValueMapper.super.mapFloatingPoint(value);
        }

        @Override
        public T mapBoolean(BooleanValue value) {
            if (Boolean.class.isAssignableFrom(this.expectedType)) {
                return this.expectedType.cast(value.booleanValue());
            }
            return (T)PartialValueMapper.super.mapBoolean(value);
        }

        @Override
        public T mapText(TextValue value) {
            if (String.class.isAssignableFrom(this.expectedType)) {
                return this.expectedType.cast(value.stringValue());
            }
            return (T)PartialValueMapper.super.mapText(value);
        }

        public T mapTextArray(TextArray value) {
            if (List.class.isAssignableFrom(this.expectedType)) {
                return this.expectedType.cast(List.of(value.asObject()));
            }
            return (T)PartialValueMapper.super.mapTextArray(value);
        }

        @Override
        public T mapSequence(SequenceValue value) {
            if (List.class.isAssignableFrom(this.expectedType)) {
                int length = value.length();
                ArrayList<Object> list = new ArrayList<Object>(length);
                for (int i = 0; i < length; ++i) {
                    list.add(value.value(i).map((ValueMapper)AsJavaObject.instance()));
                }
                return this.expectedType.cast(list);
            }
            String message = String.format(Locale.ENGLISH, "The value of `%s` must be of type `%s` but was `List`.", this.key, this.expectedType.getSimpleName());
            throw new IllegalArgumentException(message);
        }

        @Override
        public T unsupported(AnyValue value) {
            if (this.expectedType == Object.class && value instanceof Value) {
                return this.expectedType.cast(((Value)value).asObject());
            }
            String message = String.format(Locale.ENGLISH, "The value of `%s` must be of type `%s` but was `%s`.", this.key, this.expectedType.getSimpleName(), value.getTypeName());
            throw new IllegalArgumentException(message);
        }
    }
}

