/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.projection;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.immutables.value.Value;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.neo4j.gds.Orientation;
import org.neo4j.gds.annotation.Configuration;
import org.neo4j.gds.api.GraphStoreFactory;
import org.neo4j.gds.config.GraphProjectConfig;
import org.neo4j.gds.core.Aggregation;
import org.neo4j.gds.core.CypherMapAccess;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.projection.GraphProjectFromCypherAggregationConfigImpl;
import org.neo4j.gds.projection.ValueMapWrapper;
import org.neo4j.values.virtual.MapValue;

@Configuration
public interface GraphProjectFromCypherAggregationConfig
extends GraphProjectConfig {
    @Value.Default
    @Configuration.Ignore
    default public Orientation orientation() {
        return Orientation.NATURAL;
    }

    @Value.Default
    @Configuration.Ignore
    default public Aggregation aggregation() {
        return Aggregation.NONE;
    }

    @Value.Default
    default public List<String> undirectedRelationshipTypes() {
        return List.of();
    }

    @Value.Default
    default public List<String> inverseIndexedRelationshipTypes() {
        return List.of();
    }

    @Configuration.Ignore
    default public GraphStoreFactory.Supplier graphStoreFactory() {
        throw new UnsupportedOperationException("Cypher aggregation does not work over the default graph store framework");
    }

    @Value.Derived
    @Configuration.Ignore
    default public Set<String> outputFieldDenylist() {
        return Set.of("nodeCount", "relationshipCount", "readConcurrency", "sudo", "validateRelationships");
    }

    public static GraphProjectFromCypherAggregationConfig of(String userName, String graphName, MapValue config) {
        return new GraphProjectFromCypherAggregationConfigImpl(userName, graphName, ValueMapWrapper.create(config));
    }

    @TestOnly
    public static GraphProjectFromCypherAggregationConfig of(String userName, String graphName, @Nullable Map<String, Object> config) {
        return new GraphProjectFromCypherAggregationConfigImpl(userName, graphName, (CypherMapAccess)CypherMapWrapper.create(config));
    }

    @Configuration.Ignore
    default public <R> R accept(GraphProjectConfig.Cases<R> cases) {
        if (cases instanceof Cases) {
            return ((Cases)cases).cypherAggregation(this);
        }
        return null;
    }

    public static interface Visitor
    extends Cases<Void> {
        @Override
        default public Void cypherAggregation(GraphProjectFromCypherAggregationConfig cypherAggregationConfig) {
            this.visit(cypherAggregationConfig);
            return null;
        }

        default public void visit(GraphProjectFromCypherAggregationConfig cypherAggregationConfig) {
        }
    }

    public static interface Cases<R>
    extends GraphProjectConfig.Cases<R> {
        public R cypherAggregation(GraphProjectFromCypherAggregationConfig var1);
    }
}

