/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.projection;

import java.util.concurrent.atomic.AtomicBoolean;
import org.neo4j.gds.projection.PartialValueMapper;
import org.neo4j.values.AnyValue;
import org.neo4j.values.SequenceValue;
import org.neo4j.values.storable.IntegralValue;
import org.neo4j.values.virtual.VirtualNodeValue;

final class ExtractNodeId
implements PartialValueMapper<Long> {
    private final AtomicBoolean hasSeenArbitraryIds = new AtomicBoolean(false);

    ExtractNodeId() {
    }

    @Override
    public Long unsupported(AnyValue value) {
        throw ExtractNodeId.invalidNodeType(value.getTypeName());
    }

    @Override
    public Long mapSequence(SequenceValue value) {
        throw ExtractNodeId.invalidNodeType("List");
    }

    @Override
    public Long mapNode(VirtualNodeValue value) {
        return value.id();
    }

    public Long mapIntegral(IntegralValue value) {
        this.hasSeenArbitraryIds.lazySet(true);
        return value.longValue();
    }

    private static IllegalArgumentException invalidNodeType(String typeName) {
        return new IllegalArgumentException("The node has to be either a NODE or an INTEGER, but got " + typeName);
    }

    boolean hasSeenArbitraryIds() {
        return this.hasSeenArbitraryIds.get();
    }
}

