/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.projection;

import java.util.List;
import org.neo4j.common.DependencyResolver;
import org.neo4j.gds.api.DatabaseId;
import org.neo4j.gds.compat.CompatUserAggregationFunction;
import org.neo4j.gds.compat.CompatUserAggregator;
import org.neo4j.gds.compat.GraphDatabaseApiProxy;
import org.neo4j.gds.compat.Neo4jProxy;
import org.neo4j.gds.core.Username;
import org.neo4j.gds.projection.GraphAggregator;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.DefaultParameterValue;
import org.neo4j.internal.kernel.api.procs.FieldSignature;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.internal.kernel.api.procs.UserFunctionSignature;
import org.neo4j.kernel.api.procedure.Context;
import org.neo4j.kernel.api.procedure.GlobalProcedures;

public class CypherAggregation
implements CompatUserAggregationFunction {
    static final QualifiedName FUNCTION_NAME = new QualifiedName(new String[]{"gds", "alpha", "graph"}, "project");

    public static CompatUserAggregationFunction newInstance() {
        return new CypherAggregation();
    }

    public UserFunctionSignature signature() {
        return Neo4jProxy.userFunctionSignature((QualifiedName)FUNCTION_NAME, List.of(FieldSignature.inputField((String)"graphName", (Neo4jTypes.AnyType)Neo4jTypes.NTString), FieldSignature.inputField((String)"sourceNode", (Neo4jTypes.AnyType)Neo4jTypes.NTAny), FieldSignature.inputField((String)"targetNode", (Neo4jTypes.AnyType)Neo4jTypes.NTAny, (DefaultParameterValue)DefaultParameterValue.nullValue((Neo4jTypes.AnyType)Neo4jTypes.NTAny)), FieldSignature.inputField((String)"nodesConfig", (Neo4jTypes.AnyType)Neo4jTypes.NTAny, (DefaultParameterValue)DefaultParameterValue.nullValue((Neo4jTypes.AnyType)Neo4jTypes.NTAny)), FieldSignature.inputField((String)"relationshipConfig", (Neo4jTypes.AnyType)Neo4jTypes.NTAny, (DefaultParameterValue)DefaultParameterValue.nullValue((Neo4jTypes.AnyType)Neo4jTypes.NTAny)), FieldSignature.inputField((String)"configuration", (Neo4jTypes.AnyType)Neo4jTypes.NTAny, (DefaultParameterValue)DefaultParameterValue.nullValue((Neo4jTypes.AnyType)Neo4jTypes.NTAny))), (Neo4jTypes.AnyType)Neo4jTypes.NTMap, (String)"Creates a named graph in the catalog for use by algorithms.", (boolean)false, (boolean)true);
    }

    public CompatUserAggregator create(Context ctx) throws ProcedureException {
        GlobalProcedures procedures = (GlobalProcedures)GraphDatabaseApiProxy.resolveDependency((DependencyResolver)ctx.dependencyResolver(), GlobalProcedures.class);
        GraphDatabaseService databaseService = (GraphDatabaseService)procedures.lookupComponentProvider(GraphDatabaseService.class, true).apply((Object)ctx);
        Username username = (Username)procedures.lookupComponentProvider(Username.class, true).apply((Object)ctx);
        boolean runsOnCompositeDatabase = Neo4jProxy.isCompositeDatabase((GraphDatabaseService)databaseService);
        return new GraphAggregator(DatabaseId.of((GraphDatabaseService)databaseService), username.username(), !runsOnCompositeDatabase);
    }
}

