/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.TestOnly;
import org.neo4j.gds.core.ConfigKeyValidation;
import org.neo4j.gds.core.ImmutableStringAndScore;

public final class StringSimilarity {
    private static final double REQUIRED_SIMILARITY = 0.8;
    private static final double MAX_SCORE = 1.0;
    private static final double MIN_SCORE = 0.0;
    private static final double WINKLER_SCALING = 0.1;
    private static final int MAX_PREFIX_LENGTH_BOOST = 4;
    private static final CharConverter CASE_SENSITIVE = c -> c;
    private static final CharConverter CASE_INSENSITIVE = c -> Character.toLowerCase(Character.toUpperCase(c));

    public static String prettySuggestions(String prefix, CharSequence value, Collection<String> candidates) {
        StringBuilder result = new StringBuilder(prefix);
        List<String> similarCandidates = StringSimilarity.similarStrings(value, candidates);
        Optional<Object> suffix = Optional.ofNullable(similarCandidates.isEmpty() ? null : (similarCandidates.size() == 1 ? String.format(Locale.US, "Did you mean `%s`?", similarCandidates.get(0)) : String.format(Locale.US, "Did you mean one of %s?", similarCandidates.stream().collect(Collectors.joining("`, `", "[`", "`]")))));
        suffix.ifPresent(prettySuggestion -> result.append(' ').append((String)prettySuggestion));
        return result.toString();
    }

    public static List<String> similarStrings(CharSequence value, Collection<String> candidates) {
        return StringSimilarity.similarStrings(value, candidates, CASE_SENSITIVE);
    }

    public static List<String> similarStringsIgnoreCase(CharSequence value, Collection<String> candidates) {
        return StringSimilarity.similarStrings(value, candidates, CASE_INSENSITIVE);
    }

    private static List<String> similarStrings(CharSequence value, Collection<String> candidates, CharConverter converter) {
        return candidates.stream().map(candidate -> ImmutableStringAndScore.of(candidate, StringSimilarity.jaroWinkler(value, candidate, converter))).filter(candidate -> candidate.value() > 0.8).sorted().map(ConfigKeyValidation.StringAndScore::string).collect(Collectors.toList());
    }

    @TestOnly
    static double jaro(CharSequence s1, CharSequence s2) {
        return StringSimilarity.jaro(s1, s2, CASE_SENSITIVE);
    }

    private static double jaro(CharSequence s1, CharSequence s2, CharConverter converter) {
        int len1 = s1.length();
        int len2 = s2.length();
        if (len1 == 0 && len2 == 0) {
            return 1.0;
        }
        if (len1 == 0 || len2 == 0) {
            return 0.0;
        }
        if (len1 == 1 && len2 == 1) {
            return converter.convert(s1.charAt(0)) == converter.convert(s2.charAt(0)) ? 1.0 : 0.0;
        }
        int searchRange = Math.max(len1, len2) / 2 - 1;
        boolean[] consumed2 = new boolean[len2];
        Arrays.fill(consumed2, false);
        int numberOfMatches = 0;
        int numberOfTranspositions = 0;
        int matchIndex2 = 0;
        block0: for (int i = 0; i < len1; ++i) {
            int maxBound;
            char ch1 = converter.convert(s1.charAt(i));
            int minBound = i > searchRange ? Math.max(0, i - searchRange) : 0;
            if (minBound > (maxBound = Math.min(len2 - 1, i + searchRange))) continue;
            for (int j = minBound; j <= maxBound; ++j) {
                char ch2 = converter.convert(s2.charAt(j));
                if (ch1 != ch2 || consumed2[j]) continue;
                consumed2[j] = true;
                ++numberOfMatches;
                if (j < matchIndex2) {
                    ++numberOfTranspositions;
                }
                matchIndex2 = j;
                continue block0;
            }
        }
        if (numberOfMatches == 0) {
            return 0.0;
        }
        double matches = numberOfMatches;
        return (matches / (double)len1 + matches / (double)len2 + (matches - (double)numberOfTranspositions) / matches) / 3.0;
    }

    @TestOnly
    static double jaroWinkler(CharSequence s1, CharSequence s2) {
        return StringSimilarity.jaroWinkler(s1, s2, CASE_SENSITIVE);
    }

    private static double jaroWinkler(CharSequence s1, CharSequence s2, CharConverter converter) {
        char ch2;
        char ch1;
        int prefixLength;
        double jaro = StringSimilarity.jaro(s1, s2, converter);
        int commonLength = Math.min(s1.length(), s2.length());
        commonLength = Math.min(5, commonLength);
        for (prefixLength = 0; prefixLength < commonLength && (ch1 = converter.convert(s1.charAt(prefixLength))) == (ch2 = converter.convert(s2.charAt(prefixLength))); ++prefixLength) {
        }
        double jaroWinkler = jaro + 0.1 * (double)prefixLength * (1.0 - jaro);
        return Math.min(jaroWinkler, 1.0);
    }

    private StringSimilarity() {
        throw new UnsupportedOperationException("No instances");
    }

    @FunctionalInterface
    private static interface CharConverter {
        public char convert(char var1);
    }
}

