/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core;

import java.util.Locale;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public final class StringIdentifierValidations {
    private static final Pattern TRAILING_WHITESPACES_PATTERN = Pattern.compile("(^\\s)|(\\s$)");

    @Nullable
    public static String validateNoWhiteCharacter(@Nullable String input, String paramterName) {
        if (input != null && TRAILING_WHITESPACES_PATTERN.matcher(input).find()) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "`%s` must not end or begin with whitespace characters, but got `%s`.", paramterName, input));
        }
        return input;
    }

    public static String emptyToNull(String input) {
        return input == null || input.isEmpty() ? null : input;
    }
}

