/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.neo4j.gds.core.StringSimilarity;

public final class MissingParameterExceptions {
    public static IllegalArgumentException missingValueFor(String key, Collection<String> candidates) {
        return new IllegalArgumentException(MissingParameterExceptions.missingValueForMessage(key, candidates));
    }

    public static String missingValueForMessage(String key, Collection<String> candidates) {
        List<String> suggestions = StringSimilarity.similarStringsIgnoreCase(key, candidates);
        return MissingParameterExceptions.missingValueMessage(key, suggestions);
    }

    static String missingValueMessage(String key, List<String> suggestions) {
        if (suggestions.isEmpty()) {
            return String.format(Locale.US, "No value specified for the mandatory configuration parameter `%s`", key);
        }
        if (suggestions.size() == 1) {
            return String.format(Locale.ENGLISH, "No value specified for the mandatory configuration parameter `%s` (a similar parameter exists: [%s])", key, suggestions.get(0));
        }
        return String.format(Locale.ENGLISH, "No value specified for the mandatory configuration parameter `%s` (similar parameters exist: [%s])", key, String.join((CharSequence)", ", suggestions));
    }
}

