/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.immutables.value.Value;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.core.StringSimilarity;

public final class ConfigKeyValidation {
    private ConfigKeyValidation() {
    }

    public static void requireOnlyKeysFrom(Collection<String> allowedKeys, Iterable<String> configKeys) {
        TreeSet unexpectedKeys = new TreeSet(String.CASE_INSENSITIVE_ORDER);
        if (configKeys instanceof Collection) {
            unexpectedKeys.addAll((Collection)configKeys);
        } else {
            configKeys.forEach(unexpectedKeys::add);
        }
        for (String allowedKey : allowedKeys) {
            unexpectedKeys.remove(allowedKey);
        }
        if (unexpectedKeys.isEmpty()) {
            return;
        }
        List suggestions = unexpectedKeys.stream().map(invalid -> {
            List<String> candidates = StringSimilarity.similarStringsIgnoreCase(invalid, allowedKeys);
            if (configKeys instanceof Collection) {
                candidates.removeAll((Collection)configKeys);
            } else {
                configKeys.forEach(candidates::remove);
            }
            if (candidates.isEmpty()) {
                return invalid;
            }
            if (candidates.size() == 1) {
                return String.format(Locale.ENGLISH, "%s (Did you mean [%s]?)", invalid, candidates.get(0));
            }
            return String.format(Locale.ENGLISH, "%s (Did you mean one of [%s]?)", invalid, String.join((CharSequence)", ", candidates));
        }).collect(Collectors.toList());
        if (suggestions.size() == 1) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Unexpected configuration key: %s", suggestions.get(0)));
        }
        throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Unexpected configuration keys: %s", String.join((CharSequence)", ", suggestions)));
    }

    @Value.Style(allParameters=true, builderVisibility=Value.Style.BuilderVisibility.SAME, jdkOnly=true, overshadowImplementation=true, typeAbstract={"*"}, visibility=Value.Style.ImplementationVisibility.PUBLIC)
    @Value.Immutable(copy=false, builder=false)
    static interface StringAndScore
    extends Comparable<StringAndScore> {
        public String string();

        public double value();

        default public boolean isBetterThan(@Nullable StringAndScore other) {
            return other == null || this.value() > other.value();
        }

        @Override
        default public int compareTo(StringAndScore other) {
            int result = Double.compare(other.value(), this.value());
            return result != 0 ? result : this.string().compareTo(other.string());
        }
    }
}

