/*
 * Copyright (c) "Neo4j"
 * Neo4j Sweden AB [http://neo4j.com]
 *
 * This file is part of Neo4j.
 *
 * Neo4j is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.neo4j.gds.kmeans;

public class KmeansIterationStopper {
    private final long swapsBound;
    private final int maxIterations;

    public KmeansIterationStopper(
        double deltaSwaps,
        int maxIterations,
        long nodeCount
    ) {
        this.swapsBound = (long) (nodeCount * deltaSwaps);
        this.maxIterations = maxIterations;
    }

    boolean shouldQuit(long swaps, int iteration) {
        if (iteration == maxIterations) {
            return true;
        }
        if (iteration > 1 && swaps <= swapsBound) { //in the first iteration, it should never care about swaps  as it starts from a blank state
            return true;
        }
        return false;
    }
}
