/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.boltlistener;

import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import org.neo4j.bolt.connection.AccessMode;
import org.neo4j.bolt.connection.AuthInfo;
import org.neo4j.bolt.connection.AuthToken;
import org.neo4j.bolt.connection.BoltConnection;
import org.neo4j.bolt.connection.BoltConnectionState;
import org.neo4j.bolt.connection.BoltProtocolVersion;
import org.neo4j.bolt.connection.BoltServerAddress;
import org.neo4j.bolt.connection.DatabaseName;
import org.neo4j.bolt.connection.NotificationConfig;
import org.neo4j.bolt.connection.ResponseHandler;
import org.neo4j.bolt.connection.TelemetryApi;
import org.neo4j.bolt.connection.TransactionType;
import org.neo4j.bolt.connection.values.Value;
import org.neo4j.driver.internal.boltlistener.BoltConnectionListener;

final class ListeningBoltConnection
implements BoltConnection {
    private final BoltConnection delegate;
    private final BoltConnectionListener boltConnectionListener;

    public ListeningBoltConnection(BoltConnection delegate, BoltConnectionListener boltConnectionListener) {
        this.delegate = Objects.requireNonNull(delegate);
        this.boltConnectionListener = Objects.requireNonNull(boltConnectionListener);
    }

    public CompletionStage<BoltConnection> onLoop() {
        return this.delegate.onLoop().thenApply(ignored -> this);
    }

    public CompletionStage<BoltConnection> route(DatabaseName databaseName, String impersonatedUser, Set<String> bookmarks) {
        return this.delegate.route(databaseName, impersonatedUser, bookmarks).thenApply(ignored -> this);
    }

    public CompletionStage<BoltConnection> beginTransaction(DatabaseName databaseName, AccessMode accessMode, String impersonatedUser, Set<String> bookmarks, TransactionType transactionType, Duration txTimeout, Map<String, Value> txMetadata, String txType, NotificationConfig notificationConfig) {
        return this.delegate.beginTransaction(databaseName, accessMode, impersonatedUser, bookmarks, transactionType, txTimeout, txMetadata, txType, notificationConfig).thenApply(ignored -> this);
    }

    public CompletionStage<BoltConnection> runInAutoCommitTransaction(DatabaseName databaseName, AccessMode accessMode, String impersonatedUser, Set<String> bookmarks, String query, Map<String, Value> parameters, Duration txTimeout, Map<String, Value> txMetadata, NotificationConfig notificationConfig) {
        return this.delegate.runInAutoCommitTransaction(databaseName, accessMode, impersonatedUser, bookmarks, query, parameters, txTimeout, txMetadata, notificationConfig).thenApply(ignored -> this);
    }

    public CompletionStage<BoltConnection> run(String query, Map<String, Value> parameters) {
        return this.delegate.run(query, parameters).thenApply(ignored -> this);
    }

    public CompletionStage<BoltConnection> pull(long qid, long request) {
        return this.delegate.pull(qid, request).thenApply(ignored -> this);
    }

    public CompletionStage<BoltConnection> discard(long qid, long number) {
        return this.delegate.discard(qid, number).thenApply(ignored -> this);
    }

    public CompletionStage<BoltConnection> commit() {
        return this.delegate.commit().thenApply(ignored -> this);
    }

    public CompletionStage<BoltConnection> rollback() {
        return this.delegate.rollback().thenApply(ignored -> this);
    }

    public CompletionStage<BoltConnection> reset() {
        return this.delegate.reset().thenApply(ignored -> this);
    }

    public CompletionStage<BoltConnection> logoff() {
        return this.delegate.logoff().thenApply(ignored -> this);
    }

    public CompletionStage<BoltConnection> logon(AuthToken authToken) {
        return this.delegate.logon(authToken).thenApply(ignored -> this);
    }

    public CompletionStage<BoltConnection> telemetry(TelemetryApi telemetryApi) {
        return this.delegate.telemetry(telemetryApi).thenApply(ignored -> this);
    }

    public CompletionStage<BoltConnection> clear() {
        return this.delegate.clear().thenApply(ignored -> this);
    }

    public CompletionStage<Void> flush(ResponseHandler handler) {
        return this.delegate.flush(handler);
    }

    public CompletionStage<Void> forceClose(String reason) {
        return this.delegate.forceClose(reason).whenComplete((ignored, throwable) -> this.boltConnectionListener.onClose(this));
    }

    public CompletionStage<Void> close() {
        return this.delegate.close().whenComplete((ignored, throwable) -> this.boltConnectionListener.onClose(this));
    }

    public CompletionStage<Void> setReadTimeout(Duration duration) {
        return this.delegate.setReadTimeout(duration);
    }

    public BoltConnectionState state() {
        return this.delegate.state();
    }

    public CompletionStage<AuthInfo> authInfo() {
        return this.delegate.authInfo();
    }

    public String serverAgent() {
        return this.delegate.serverAgent();
    }

    public BoltServerAddress serverAddress() {
        return this.delegate.serverAddress();
    }

    public BoltProtocolVersion protocolVersion() {
        return this.delegate.protocolVersion();
    }

    public boolean telemetrySupported() {
        return this.delegate.telemetrySupported();
    }

    public boolean serverSideRoutingEnabled() {
        return this.delegate.serverSideRoutingEnabled();
    }

    public Optional<Duration> defaultReadTimeout() {
        return this.delegate.defaultReadTimeout();
    }
}

