/*
 * Copyright (c) "Neo4j"
 * Neo4j Sweden AB [https://neo4j.com]
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.neo4j.driver.internal.bolt.routedimpl;

import java.net.UnknownHostException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Supplier;
import org.neo4j.driver.internal.bolt.api.AuthToken;
import org.neo4j.driver.internal.bolt.api.BoltConnectionProvider;
import org.neo4j.driver.internal.bolt.api.BoltProtocolVersion;
import org.neo4j.driver.internal.bolt.api.BoltServerAddress;
import org.neo4j.driver.internal.bolt.api.SecurityPlan;

/**
 * Provides cluster composition lookup capabilities and initial router address resolution.
 */
public interface Rediscovery {
    CompletionStage<ClusterCompositionLookupResult> lookupClusterComposition(
            SecurityPlan securityPlan,
            RoutingTable routingTable,
            Function<BoltServerAddress, BoltConnectionProvider> connectionProviderGetter,
            Set<String> bookmarks,
            String impersonatedUser,
            Supplier<CompletionStage<AuthToken>> authTokenStageSupplier,
            BoltProtocolVersion minVersion);

    List<BoltServerAddress> resolve() throws UnknownHostException;
}
