/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.springframework.boot.autoconfigure;

import java.net.URI;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.Config;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;
import org.neo4j.driver.springframework.boot.autoconfigure.Neo4jDriverProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
class DriverConfiguration {
    DriverConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean(value={Driver.class})
    @ConditionalOnProperty(prefix="org.neo4j.driver", name={"uri"})
    Driver neo4jDriver(Neo4jDriverProperties driverProperties) {
        AuthToken authToken = driverProperties.getAuthentication().asAuthToken();
        Config config = driverProperties.asDriverConfig();
        return GraphDatabase.driver((URI)driverProperties.getUri(), (AuthToken)authToken, (Config)config);
    }
}

