/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.springframework.boot.actuate;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Session;
import org.neo4j.driver.SessionConfig;
import org.neo4j.driver.exceptions.SessionExpiredException;
import org.neo4j.driver.summary.DatabaseInfo;
import org.neo4j.driver.summary.ResultSummary;
import org.neo4j.driver.summary.ServerInfo;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.util.StringUtils;

public final class Neo4jHealthIndicator
extends AbstractHealthIndicator {
    private static final Log logger = LogFactory.getLog(Neo4jHealthIndicator.class);
    static final String CYPHER = "RETURN 1 AS result";
    static final String MESSAGE_HEALTH_CHECK_FAILED = "Neo4j health check failed";
    static final String MESSAGE_SESSION_EXPIRED = "Neo4j session has expired, retrying one single time to retrieve server health.";
    static final SessionConfig DEFAULT_SESSION_CONFIG = SessionConfig.builder().withDefaultAccessMode(AccessMode.WRITE).build();
    private final Driver driver;

    public Neo4jHealthIndicator(Driver driver) {
        super(MESSAGE_HEALTH_CHECK_FAILED);
        this.driver = driver;
    }

    protected void doHealthCheck(Health.Builder builder) {
        try {
            ResultSummary resultSummary;
            try {
                resultSummary = this.runHealthCheckQuery();
            }
            catch (SessionExpiredException sessionExpiredException) {
                logger.warn((Object)MESSAGE_SESSION_EXPIRED);
                resultSummary = this.runHealthCheckQuery();
            }
            Neo4jHealthIndicator.buildStatusUp(resultSummary, builder);
        }
        catch (Exception ex) {
            builder.down().withException((Throwable)ex);
        }
    }

    static Health.Builder buildStatusUp(ResultSummary resultSummary, Health.Builder builder) {
        ServerInfo serverInfo = resultSummary.server();
        DatabaseInfo databaseInfo = resultSummary.database();
        builder.up().withDetail("server", (Object)(serverInfo.version() + "@" + serverInfo.address()));
        if (StringUtils.hasText((String)databaseInfo.name())) {
            builder.withDetail("database", (Object)databaseInfo.name());
        }
        return builder;
    }

    ResultSummary runHealthCheckQuery() {
        try (Session session = this.driver.session(DEFAULT_SESSION_CONFIG);){
            ResultSummary resultSummary;
            ResultSummary resultSummary2 = resultSummary = session.run(CYPHER).consume();
            return resultSummary2;
        }
    }
}

