/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.reactive;

import org.neo4j.driver.internal.async.UnmanagedTransaction;
import org.neo4j.driver.internal.reactive.RxUtils;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.Mono;
import org.reactivestreams.Publisher;

public abstract class AbstractReactiveTransaction {
    protected final UnmanagedTransaction tx;

    protected AbstractReactiveTransaction(UnmanagedTransaction tx) {
        this.tx = tx;
    }

    protected <T> Publisher<T> doCommit() {
        return RxUtils.createEmptyPublisher(this.tx::commitAsync);
    }

    protected <T> Publisher<T> doRollback() {
        return RxUtils.createEmptyPublisher(this.tx::rollbackAsync);
    }

    protected Publisher<Void> doClose() {
        return this.close(false);
    }

    protected Publisher<Boolean> doIsOpen() {
        return Mono.just(this.tx.isOpen());
    }

    public Publisher<Void> close(boolean commit) {
        return RxUtils.createEmptyPublisher(() -> this.tx.closeAsync(commit));
    }
}

