/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.ast.factory;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.neo4j.cypher.internal.ast.factory.ConstraintType;
import org.neo4j.cypher.internal.ast.factory.CreateIndexTypes;
import org.neo4j.cypher.internal.ast.factory.HintIndexType;
import org.neo4j.cypher.internal.ast.factory.ShowCommandFilterTypes;

public interface ASTExceptionFactory {
    public static final String invalidDropCommand = "Unsupported drop constraint command: Please delete the constraint by name instead";
    public static final String periodicCommitNotSupported = "The PERIODIC COMMIT query hint is no longer supported. Please use CALL { ... } IN TRANSACTIONS instead.";

    public Exception syntaxException(String var1, List<String> var2, Exception var3, int var4, int var5, int var6);

    public Exception syntaxException(Exception var1, int var2, int var3, int var4);

    public static String relationshipPatternNotAllowed(ConstraintType type) {
        return String.format("'%s' does not allow relationship patterns", type.description());
    }

    public static String nodePatternNotAllowed(ConstraintType type) {
        return String.format("'%s' does not allow node patterns", type.description());
    }

    public static String onlySinglePropertyAllowed(ConstraintType type) {
        return String.format("Constraint type '%s' does not allow multiple properties", type.description());
    }

    public static String invalidShowFilterType(String command, ShowCommandFilterTypes got) {
        return String.format("Filter type %s is not defined for show %s command.", got.description(), command);
    }

    public static String invalidCreateIndexType(CreateIndexTypes got) {
        return String.format("Index type %s is not defined for create index command.", got.description());
    }

    public static String invalidDotsInRemoteAliasName(String name) {
        return String.format("'.' is not a valid character in the remote alias name '%s'. Remote alias names using '.' must be quoted with backticks e.g. `remote.alias`.", name);
    }

    public static String invalidHintIndexType(HintIndexType got) {
        String HINT_TYPES = Arrays.stream(HintIndexType.values()).filter(hintIndexType -> hintIndexType != HintIndexType.BTREE && hintIndexType != HintIndexType.ANY).map(Enum::name).collect(Collectors.collectingAndThen(Collectors.toList(), ASTExceptionFactory.joiningLastDelimiter(", ", " or ")));
        if (got == HintIndexType.BTREE) {
            return String.format("Index type %s is no longer supported for USING index hint. Use %s instead.", got.name(), HINT_TYPES);
        }
        return String.format("Index type %s is not defined for USING index hint. Use %s instead.", got.name(), HINT_TYPES);
    }

    private static Function<List<String>, String> joiningLastDelimiter(String delimiter, String lastDelimiter) {
        return list -> {
            int last = list.size() - 1;
            return String.join((CharSequence)lastDelimiter, String.join((CharSequence)delimiter, list.subList(0, last)), (CharSequence)list.get(last));
        };
    }
}

