/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.time.Duration;
import java.util.Objects;
import java.util.function.Function;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.facade.DatabaseManagementServiceFactory;
import org.neo4j.graphdb.facade.ExternalDependencies;
import org.neo4j.graphdb.factory.module.GlobalModule;
import org.neo4j.graphdb.factory.module.edition.AbstractEditionModule;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.io.locker.Locker;
import org.neo4j.kernel.impl.factory.DbmsInfo;
import org.neo4j.kernel.internal.locker.FileLockerService;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.SimpleLogService;
import org.neo4j.time.SystemNanoClock;

public class TestDatabaseManagementServiceFactory
extends DatabaseManagementServiceFactory {
    private final FileSystemAbstraction fileSystem;
    private InternalLogProvider internalLogProvider;
    private final SystemNanoClock clock;

    public TestDatabaseManagementServiceFactory(DbmsInfo dbmsInfo, Function<GlobalModule, AbstractEditionModule> editionFactory, FileSystemAbstraction fileSystem, SystemNanoClock clock, InternalLogProvider internalLogProvider) {
        super(dbmsInfo, editionFactory);
        this.fileSystem = Objects.requireNonNull(fileSystem);
        this.clock = clock;
        this.internalLogProvider = internalLogProvider;
    }

    protected GlobalModule createGlobalModule(Config config, ExternalDependencies dependencies) {
        config.setIfNotSet(GraphDatabaseSettings.shutdown_transaction_end_timeout, (Object)Duration.ZERO);
        if (!this.fileSystem.isPersistent()) {
            config.setIfNotSet(GraphDatabaseSettings.keep_logical_logs, (Object)"1 files");
        }
        return new TestDatabaseGlobalModule(config, this.dbmsInfo, dependencies);
    }

    class TestDatabaseGlobalModule
    extends GlobalModule {
        TestDatabaseGlobalModule(Config config, DbmsInfo dbmsInfo, ExternalDependencies dependencies) {
            super(config, dbmsInfo, dependencies);
        }

        protected FileSystemAbstraction createFileSystemAbstraction() {
            return TestDatabaseManagementServiceFactory.this.fileSystem;
        }

        protected LogService createLogService(InternalLogProvider userLogProvider) {
            if (TestDatabaseManagementServiceFactory.this.internalLogProvider == null) {
                if (TestDatabaseManagementServiceFactory.this.fileSystem.isPersistent()) {
                    return super.createLogService(userLogProvider);
                }
                TestDatabaseManagementServiceFactory.this.internalLogProvider = NullLogProvider.getInstance();
            }
            return new SimpleLogService(userLogProvider, TestDatabaseManagementServiceFactory.this.internalLogProvider, true);
        }

        protected SystemNanoClock createClock() {
            return TestDatabaseManagementServiceFactory.this.clock != null ? TestDatabaseManagementServiceFactory.this.clock : super.createClock();
        }

        protected FileLockerService createFileLockerService() {
            if (TestDatabaseManagementServiceFactory.this.fileSystem.isPersistent()) {
                return super.createFileLockerService();
            }
            return new ImpermanentLockerService();
        }
    }

    private static class ImpermanentLockerService
    implements FileLockerService {
        private ImpermanentLockerService() {
        }

        public Locker createStoreLocker(FileSystemAbstraction fileSystem, Neo4jLayout storeLayout) {
            return new Locker(fileSystem, storeLayout.storeLockFile());
        }

        public Locker createDatabaseLocker(FileSystemAbstraction fileSystem, DatabaseLayout databaseLayout) {
            return new Locker(fileSystem, databaseLayout.databaseLockFile());
        }
    }
}

