/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.format;

import java.util.Map;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.SettingMigrator;
import org.neo4j.logging.InternalLog;

public class FormatOverrideMigrator
implements SettingMigrator {
    private static final String OVERRIDE_STORE_FORMAT_KEY = "NEO4J_OVERRIDE_STORE_FORMAT";

    public void migrate(Map<String, String> values, Map<String, String> defaultValues, InternalLog log) {
        String overrideStoreFormat = System.getProperty(OVERRIDE_STORE_FORMAT_KEY);
        if (overrideStoreFormat != null && !values.containsKey(GraphDatabaseSettings.db_format.name())) {
            try {
                defaultValues.put(GraphDatabaseSettings.db_format.name(), overrideStoreFormat);
                defaultValues.put(GraphDatabaseInternalSettings.include_versions_under_development.name(), "true");
            }
            catch (RuntimeException ex) {
                log.warn("Unable to override the database format to " + overrideStoreFormat, (Throwable)ex);
            }
        }
    }
}

