/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.IOException;
import java.nio.file.Path;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.BinarySupportedKernelVersions;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogPositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommand;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderReader;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.CommandReaderFactory;

public class TxLogValidationUtils {
    private TxLogValidationUtils() {
    }

    public static LogHeader assertLogHeaderExpectedVersion(FileSystemAbstraction fs, LogFiles logFiles, long logVersion, KernelVersion expectedVersion) throws IOException {
        LogHeader logHeader = LogHeaderReader.readLogHeader((FileSystemAbstraction)fs, (Path)logFiles.getLogFile().getLogFileForVersion(logVersion), (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        Assertions.assertThat((Comparable)logHeader.getKernelVersion()).isEqualTo((Object)expectedVersion);
        return logHeader;
    }

    public static LogHeader assertLogHeaderExpectedVersion(FileSystemAbstraction fs, LogFiles logFiles, long logVersion, KernelVersion expectedVersion, long lastExpectedAppendIndex) throws IOException {
        LogHeader logHeader = TxLogValidationUtils.assertLogHeaderExpectedVersion(fs, logFiles, logVersion, expectedVersion);
        Assertions.assertThat((long)logHeader.getLastAppendIndex()).isEqualTo(lastExpectedAppendIndex);
        return logHeader;
    }

    public static void assertLogHeaderExpectedVersion(FileSystemAbstraction fs, LogFiles logFiles, long logVersion, KernelVersion expectedVersion, long lastExpectedAppendIndex, int checksum) throws IOException {
        LogHeader logHeader = TxLogValidationUtils.assertLogHeaderExpectedVersion(fs, logFiles, logVersion, expectedVersion, lastExpectedAppendIndex);
        Assertions.assertThat((int)logHeader.getPreviousLogFileChecksum()).isEqualTo(checksum);
    }

    public static void assertWholeTransactionsWithCorrectVersionInSpecificLogVersion(LogFile logFile, long logVersion, KernelVersion kernelVersion, int expectedNbrTxs, CommandReaderFactory commandReaderFactory) throws IOException {
        Assertions.assertThat((int)TxLogValidationUtils.assertWholeTransactionsWithCorrectVersionInSpecificLogVersion(logFile, logVersion, kernelVersion, commandReaderFactory)).isEqualTo(expectedNbrTxs);
    }

    public static int assertWholeTransactionsWithCorrectVersionInSpecificLogVersion(LogFile logFile, long logVersion, KernelVersion kernelVersion, CommandReaderFactory commandReaderFactory) throws IOException {
        return TxLogValidationUtils.assertWholeTransactionsIn(logFile, logVersion, startEntry -> Assertions.assertThat((Comparable)startEntry.kernelVersion()).isEqualTo((Object)kernelVersion), commitEntry -> {}, commandReaderFactory);
    }

    public static int assertWholeTransactionsIn(LogFile logFile, long logVersion, Consumer<LogEntryStart> extraStartCheck, Consumer<LogEntryCommit> extraCommitCheck, CommandReaderFactory commandReaderFactory) throws IOException {
        int transactions = 0;
        try (ReadableLogChannel reader = logFile.getReader(logFile.extractHeader(logVersion).getStartPosition(), LogVersionBridge.NO_MORE_CHANNELS);){
            LogEntry entry;
            VersionAwareLogEntryReader entryReader = new VersionAwareLogEntryReader(commandReaderFactory, new BinarySupportedKernelVersions(Config.defaults((Setting)GraphDatabaseInternalSettings.latest_kernel_version, (Object)KernelVersion.GLORIOUS_FUTURE.version())));
            boolean inTx = false;
            while ((entry = entryReader.readLogEntry((ReadableLogPositionAwareChannel)reader)) != null) {
                if (!inTx) {
                    org.junit.jupiter.api.Assertions.assertInstanceOf(LogEntryStart.class, (Object)entry);
                    extraStartCheck.accept((LogEntryStart)entry);
                    inTx = true;
                    continue;
                }
                org.junit.jupiter.api.Assertions.assertTrue((entry instanceof LogEntryCommand || entry instanceof LogEntryCommit ? 1 : 0) != 0);
                if (!(entry instanceof LogEntryCommit)) continue;
                LogEntryCommit commit = (LogEntryCommit)entry;
                inTx = false;
                ++transactions;
                extraCommitCheck.accept(commit);
            }
            org.junit.jupiter.api.Assertions.assertFalse((boolean)inTx);
        }
        return transactions;
    }
}

